/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.forwarded;

import java.io.IOException;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.connection.channel.forwarded.ForwardedChannelOpener;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractForwardedChannelOpener
implements ForwardedChannelOpener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String chanType;
    protected final Connection conn;

    protected AbstractForwardedChannelOpener(String chanType, Connection conn) {
        this.chanType = chanType;
        this.conn = conn;
    }

    public String getChannelType() {
        return this.chanType;
    }

    protected void callListener(final ConnectListener listener, final Channel.Forwarded chan) {
        new Thread(){
            {
                this.setName("ConnectListener");
            }

            public void run() {
                try {
                    listener.gotConnect(chan);
                }
                catch (IOException logged) {
                    AbstractForwardedChannelOpener.this.log.warn("In callback to {}: {}", (Object)listener, (Object)logged);
                    if (chan.isOpen()) {
                        IOUtils.closeQuietly(chan);
                    }
                    try {
                        chan.reject(OpenFailException.Reason.CONNECT_FAILED, "");
                    }
                    catch (TransportException cantdonthn) {
                        AbstractForwardedChannelOpener.this.log.warn("Error rejecting {}: {}", (Object)chan, (Object)cantdonthn);
                    }
                }
            }
        }.start();
    }
}

