/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.util.Collections;
import java.util.Set;
import net.schmizz.sshj.xfer.FilePermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMode {
    private final int mask;
    private final Type type;
    private final Set<FilePermission> perms;

    public FileMode(int mask) {
        this.mask = mask;
        this.type = Type.fromMask(this.getTypeMask());
        this.perms = FilePermission.fromMask(this.getPermissionsMask());
    }

    public int getMask() {
        return this.mask;
    }

    public int getTypeMask() {
        return this.mask & 0x3F000;
    }

    public int getPermissionsMask() {
        return this.mask & 0xFFF;
    }

    public Type getType() {
        return this.type;
    }

    public Set<FilePermission> getPermissions() {
        return Collections.unmodifiableSet(this.perms);
    }

    public String toString() {
        return "[mask=" + Integer.toOctalString(this.mask) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BLOCK_SPECIAL(24576),
        CHAR_SPECIAL(8192),
        FIFO_SPECIAL(4096),
        SOCKET_SPECIAL(49152),
        REGULAR(32768),
        DIRECTORY(16384),
        SYMKLINK(40960),
        UNKNOWN(0);

        private final int val;

        private Type(int val) {
            this.val = val;
        }

        public static Type fromMask(int mask) {
            for (Type t : Type.values()) {
                if (t.val != mask) continue;
                return t;
            }
            return UNKNOWN;
        }

        public static int toMask(Type t) {
            return t.val;
        }
    }
}

