/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.Closeable;
import java.io.IOException;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.Request;
import net.schmizz.sshj.sftp.Requester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RemoteResource
implements Closeable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Requester requester;
    protected final String path;
    protected final String handle;

    protected RemoteResource(Requester requester, String path, String handle) {
        this.requester = requester;
        this.path = path;
        this.handle = handle;
    }

    public String getPath() {
        return this.path;
    }

    protected Request newRequest(PacketType type) {
        return (Request)this.requester.newRequest(type).putString(this.handle);
    }

    public void close() throws IOException {
        this.log.info("Closing `{}`", (Object)this);
        this.requester.doRequest(this.newRequest(PacketType.CLOSE)).ensureStatusPacketIsOK();
    }

    public String toString() {
        return "RemoteResource{" + this.path + "}";
    }
}

