/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.PathComponents;

public class RemoteResourceInfo {
    private final PathComponents comps;
    private final FileAttributes attrs;

    public RemoteResourceInfo(String parent, String name, FileAttributes attrs) {
        this(new PathComponents(parent, name), attrs);
    }

    public RemoteResourceInfo(PathComponents comps, FileAttributes attrs) {
        this.comps = comps;
        this.attrs = attrs;
    }

    public String getPath() {
        return this.comps.getPath();
    }

    public String getParent() {
        return this.comps.getParent();
    }

    public String getName() {
        return this.comps.getName();
    }

    public FileAttributes getAttributes() {
        return this.attrs;
    }

    public boolean isRegularFile() {
        return this.attrs.getType() == FileMode.Type.REGULAR;
    }

    public boolean isDirectory() {
        return this.attrs.getType() == FileMode.Type.DIRECTORY;
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteResourceInfo) {
            RemoteResourceInfo that = (RemoteResourceInfo)o;
            if (this.comps.equals(that.comps)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.comps.hashCode();
    }

    public String toString() {
        return "[" + (Object)((Object)this.attrs.getType()) + "] " + this.getPath();
    }
}

