/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response
extends SFTPPacket<Response> {
    private final PacketType type = this.readType();
    private final long reqID = this.readLong();

    public Response(Buffer<Response> pk) {
        super(pk);
    }

    public long getRequestID() {
        return this.reqID;
    }

    public PacketType getType() {
        return this.type;
    }

    public StatusCode readStatusCode() {
        return StatusCode.fromInt(this.readInt());
    }

    public Response ensurePacketTypeIs(PacketType pt) throws SFTPException {
        if (this.getType() != pt) {
            if (this.getType() == PacketType.STATUS) {
                throw new SFTPException(this.readStatusCode(), this.readString());
            }
            throw new SFTPException("Unexpected packet " + (Object)((Object)this.getType()));
        }
        return this;
    }

    public Response ensureStatusPacketIsOK() throws SFTPException {
        return this.ensurePacketTypeIs(PacketType.STATUS).ensureStatusIs(StatusCode.OK);
    }

    public Response ensureStatusIs(StatusCode acceptable) throws SFTPException {
        StatusCode sc = this.readStatusCode();
        if (sc != acceptable) {
            throw new SFTPException(sc, this.readString());
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusCode {
        UNKNOWN(-1),
        OK(0),
        EOF(1),
        NO_SUCH_FILE(2),
        PERMISSION_DENIED(3),
        FAILURE(4),
        BAD_MESSAGE(5),
        NO_CONNECTION(6),
        CONNECITON_LOST(7),
        OP_UNSUPPORTED(8);

        private final int code;

        public static StatusCode fromInt(int code) {
            for (StatusCode s : StatusCode.values()) {
                if (s.code != code) continue;
                return s;
            }
            return UNKNOWN;
        }

        private StatusCode(int code) {
            this.code = code;
        }
    }
}

