/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPFileTransfer;
import net.schmizz.sshj.xfer.FilePermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFTPClient {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SFTPEngine sftp;
    private final SFTPFileTransfer xfer;

    public SFTPClient(SessionFactory ssh) throws IOException {
        this.sftp = new SFTPEngine(ssh).init();
        this.xfer = new SFTPFileTransfer(this.sftp);
    }

    public SFTPEngine getSFTPEngine() {
        return this.sftp;
    }

    public SFTPFileTransfer getFileTansfer() {
        return this.xfer;
    }

    public List<RemoteResourceInfo> ls(String path) throws IOException {
        return this.ls(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RemoteResourceInfo> ls(String path, RemoteResourceFilter filter) throws IOException {
        RemoteDirectory dir = this.sftp.openDir(path);
        try {
            List<RemoteResourceInfo> list = dir.scan(filter);
            return list;
        }
        finally {
            dir.close();
        }
    }

    public RemoteFile open(String filename, Set<OpenMode> mode, FileAttributes attrs) throws IOException {
        this.log.debug("Opening `{}`", (Object)filename);
        return this.sftp.open(filename, mode, attrs);
    }

    public RemoteFile open(String filename, Set<OpenMode> mode) throws IOException {
        return this.open(filename, mode, new FileAttributes());
    }

    public RemoteFile open(String filename) throws IOException {
        return this.open(filename, EnumSet.of(OpenMode.READ));
    }

    public void mkdir(String dirname) throws IOException {
        this.sftp.makeDir(dirname);
    }

    public void rename(String oldpath, String newpath) throws IOException {
        this.sftp.rename(oldpath, newpath);
    }

    public void rm(String filename) throws IOException {
        this.sftp.remove(filename);
    }

    public void rmdir(String dirname) throws IOException {
        this.sftp.removeDir(dirname);
    }

    public void symlink(String linkpath, String targetpath) throws IOException {
        this.sftp.symlink(linkpath, targetpath);
    }

    public int version() {
        return this.sftp.getOperativeProtocolVersion();
    }

    public void setattr(String path, FileAttributes attrs) throws IOException {
        this.sftp.setAttributes(path, attrs);
    }

    public int uid(String path) throws IOException {
        return this.stat(path).getUID();
    }

    public int gid(String path) throws IOException {
        return this.stat(path).getGID();
    }

    public long atime(String path) throws IOException {
        return this.stat(path).getAtime();
    }

    public long mtime(String path) throws IOException {
        return this.stat(path).getMtime();
    }

    public Set<FilePermission> perms(String path) throws IOException {
        return this.stat(path).getPermissions();
    }

    public FileMode mode(String path) throws IOException {
        return this.stat(path).getMode();
    }

    public FileMode.Type type(String path) throws IOException {
        return this.stat(path).getType();
    }

    public String readlink(String path) throws IOException {
        return this.sftp.readLink(path);
    }

    public FileAttributes stat(String path) throws IOException {
        return this.sftp.stat(path);
    }

    public FileAttributes lstat(String path) throws IOException {
        return this.sftp.lstat(path);
    }

    public void chown(String path, int uid) throws IOException {
        this.setattr(path, new FileAttributes.Builder().withUIDGID(uid, this.gid(path)).build());
    }

    public void chmod(String path, int perms) throws IOException {
        this.setattr(path, new FileAttributes.Builder().withPermissions(perms).build());
    }

    public void chgrp(String path, int gid) throws IOException {
        this.setattr(path, new FileAttributes.Builder().withUIDGID(this.uid(path), gid).build());
    }

    public void truncate(String path, long size) throws IOException {
        this.setattr(path, new FileAttributes.Builder().withSize(size).build());
    }

    public String canonicalize(String path) throws IOException {
        return this.sftp.canonicalize(path);
    }

    public long size(String path) throws IOException {
        return this.stat(path).getSize();
    }

    public void get(String source, String dest) throws IOException {
        this.xfer.download(source, dest);
    }

    public void put(String source, String dest) throws IOException {
        this.xfer.upload(source, dest);
    }
}

