/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.PathHelper;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.xfer.AbstractFileTransfer;
import net.schmizz.sshj.xfer.FileTransfer;
import net.schmizz.sshj.xfer.FileTransferUtil;
import net.schmizz.sshj.xfer.ModeGetter;
import net.schmizz.sshj.xfer.ModeSetter;

public class SFTPFileTransfer
extends AbstractFileTransfer
implements FileTransfer {
    private final SFTPEngine sftp;
    private final PathHelper pathHelper;
    private volatile FileFilter uploadFilter = defaultLocalFilter;
    private volatile RemoteResourceFilter downloadFilter = defaultRemoteFilter;
    private static final FileFilter defaultLocalFilter = new FileFilter(){

        public boolean accept(File pathName) {
            return true;
        }
    };
    private static final RemoteResourceFilter defaultRemoteFilter = new RemoteResourceFilter(){

        public boolean accept(RemoteResourceInfo resource) {
            return true;
        }
    };

    public SFTPFileTransfer(SFTPEngine sftp) {
        this.sftp = sftp;
        this.pathHelper = new PathHelper(sftp);
    }

    public void upload(String source, String dest) throws IOException {
        new Uploader(this.getModeGetter(), this.getUploadFilter()).upload(new File(source), dest);
    }

    public void download(String source, String dest) throws IOException {
        PathComponents pathComponents = this.pathHelper.getComponents(source);
        FileAttributes attributes = this.sftp.stat(source);
        new Downloader(this.getModeSetter(), this.getDownloadFilter()).download(new RemoteResourceInfo(pathComponents, attributes), new File(dest));
    }

    public void setUploadFilter(FileFilter uploadFilter) {
        this.uploadFilter = this.uploadFilter == null ? defaultLocalFilter : uploadFilter;
    }

    public void setDownloadFilter(RemoteResourceFilter downloadFilter) {
        this.downloadFilter = this.downloadFilter == null ? defaultRemoteFilter : downloadFilter;
    }

    public FileFilter getUploadFilter() {
        return this.uploadFilter;
    }

    public RemoteResourceFilter getDownloadFilter() {
        return this.downloadFilter;
    }

    private class Uploader {
        private final ModeGetter modeGetter;
        private final FileFilter filter;

        Uploader(ModeGetter modeGetter, FileFilter filter) {
            this.modeGetter = modeGetter;
            this.filter = filter;
        }

        public FileAttributes getAttributes(File local) throws IOException {
            FileAttributes.Builder builder = new FileAttributes.Builder().withPermissions(this.modeGetter.getPermissions(local));
            if (this.modeGetter.preservesTimes()) {
                builder.withAtimeMtime(this.modeGetter.getLastAccessTime(local), this.modeGetter.getLastModifiedTime(local));
            }
            return builder.build();
        }

        private void setAttributes(FileAttributes current, File local, String remote) throws IOException {
            FileAttributes attrs = this.getAttributes(local);
            if (current == null || current.getMode().getPermissionsMask() != attrs.getMode().getPermissionsMask() || this.modeGetter.preservesTimes() && (attrs.getAtime() != current.getAtime() || attrs.getMtime() != current.getMtime())) {
                SFTPFileTransfer.this.sftp.setAttributes(remote, attrs);
            }
        }

        private String prepareDir(File local, String remote) throws IOException {
            FileAttributes attrs;
            try {
                attrs = SFTPFileTransfer.this.sftp.stat(remote);
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("probeDir: {} does not exist, creating", (Object)remote);
                    SFTPFileTransfer.this.sftp.makeDir(remote, this.getAttributes(local));
                    return remote;
                }
                throw e;
            }
            if (attrs.getMode().getType() == FileMode.Type.DIRECTORY) {
                if (SFTPFileTransfer.this.pathHelper.getComponents(remote).getName().equals(local.getName())) {
                    SFTPFileTransfer.this.log.debug("probeDir: {} already exists", (Object)remote);
                    this.setAttributes(attrs, local, remote);
                    return remote;
                }
                SFTPFileTransfer.this.log.debug("probeDir: {} already exists, path adjusted for {}", (Object)remote, (Object)local.getName());
                return this.prepareDir(local, PathComponents.adjustForParent(remote, local.getName()));
            }
            throw new IOException((Object)((Object)attrs.getMode().getType()) + " file already exists at " + remote);
        }

        private String prepareFile(File local, String remote) throws IOException {
            FileAttributes attrs;
            try {
                attrs = SFTPFileTransfer.this.sftp.stat(remote);
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("probeFile: {} does not exist", (Object)remote);
                    return remote;
                }
                throw e;
            }
            if (attrs.getMode().getType() == FileMode.Type.DIRECTORY) {
                SFTPFileTransfer.this.log.debug("probeFile: {} was directory, path adjusted for {}", (Object)remote, (Object)local.getName());
                remote = PathComponents.adjustForParent(remote, local.getName());
                return remote;
            }
            SFTPFileTransfer.this.log.debug("probeFile: {} is a {} file that will be replaced", (Object)remote, (Object)attrs.getMode().getType());
            return remote;
        }

        private void uploadDir(File local, String remote) throws IOException {
            String adjusted = this.prepareDir(local, remote);
            for (File f : local.listFiles(this.filter)) {
                this.upload(f, adjusted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadFile(File local, String remote) throws IOException {
            String adjusted = this.prepareFile(local, remote);
            RemoteFile rf = SFTPFileTransfer.this.sftp.open(adjusted, EnumSet.of(OpenMode.WRITE, OpenMode.CREAT, OpenMode.TRUNC), this.getAttributes(local));
            try {
                FileInputStream fis = new FileInputStream(local);
                try {
                    StreamCopier.copy(fis, rf.getOutputStream(), SFTPFileTransfer.this.sftp.getSubsystem().getRemoteMaxPacketSize() - rf.getOutgoingPacketOverhead(), false);
                }
                finally {
                    fis.close();
                }
            }
            finally {
                rf.close();
            }
        }

        void upload(File local, String remote) throws IOException {
            SFTPFileTransfer.this.log.info("Uploading [{}] to [{}]", (Object)local, (Object)remote);
            if (local.isDirectory()) {
                this.uploadDir(local, remote);
            } else if (local.isFile()) {
                this.uploadFile(local, remote);
            } else {
                throw new IOException(local + " is not a file or directory");
            }
        }
    }

    private class Downloader {
        private final ModeSetter modeSetter;
        private final RemoteResourceFilter filter;

        Downloader(ModeSetter modeSetter, RemoteResourceFilter filter) {
            this.modeSetter = modeSetter;
            this.filter = filter;
        }

        private void setAttributes(RemoteResourceInfo remote, File local) throws IOException {
            FileAttributes attrs = remote.getAttributes();
            this.modeSetter.setPermissions(local, attrs.getMode().getPermissionsMask());
            if (this.modeSetter.preservesTimes() && attrs.has(FileAttributes.Flag.ACMODTIME)) {
                this.modeSetter.setLastAccessedTime(local, attrs.getAtime());
                this.modeSetter.setLastModifiedTime(local, attrs.getMtime());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadFile(RemoteResourceInfo remote, File local) throws IOException {
            local = FileTransferUtil.getTargetFile(local, remote.getName());
            this.setAttributes(remote, local);
            RemoteFile rf = SFTPFileTransfer.this.sftp.open(remote.getPath());
            try {
                FileOutputStream fos = new FileOutputStream(local);
                try {
                    StreamCopier.copy(rf.getInputStream(), fos, SFTPFileTransfer.this.sftp.getSubsystem().getLocalMaxPacketSize(), false);
                }
                finally {
                    fos.close();
                }
            }
            finally {
                rf.close();
            }
        }

        private void downloadDir(RemoteResourceInfo remote, File local) throws IOException {
            local = FileTransferUtil.getTargetDirectory(local, remote.getName());
            this.setAttributes(remote, local);
            RemoteDirectory rd = SFTPFileTransfer.this.sftp.openDir(remote.getPath());
            for (RemoteResourceInfo rri : rd.scan(this.filter)) {
                this.download(rri, new File(local.getPath(), rri.getName()));
            }
            rd.close();
        }

        void download(RemoteResourceInfo remote, File local) throws IOException {
            SFTPFileTransfer.this.log.info("Downloading [{}] to [{}]", (Object)remote, (Object)local);
            switch (remote.getAttributes().getType()) {
                case DIRECTORY: {
                    this.downloadDir(remote, local);
                    break;
                }
                case UNKNOWN: {
                    SFTPFileTransfer.this.log.warn("Server did not supply information about the type of file at `{}` -- assuming it is a regular file!");
                }
                case REGULAR: {
                    this.downloadFile(remote, local);
                    break;
                }
                default: {
                    throw new IOException(remote + " is not a regular file or directory");
                }
            }
        }
    }
}

