/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.PacketType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFTPPacket<T extends SFTPPacket<T>>
extends Buffer<T> {
    public SFTPPacket() {
    }

    public SFTPPacket(Buffer<T> buf) {
        super(buf);
    }

    public SFTPPacket(PacketType pt) {
        this.putByte(pt.toByte());
    }

    public FileAttributes readFileAttributes() {
        FileAttributes.Builder builder = new FileAttributes.Builder();
        int mask = this.readInt();
        if (FileAttributes.Flag.SIZE.isSet(mask)) {
            builder.withSize(this.readUINT64());
        }
        if (FileAttributes.Flag.UIDGID.isSet(mask)) {
            builder.withUIDGID(this.readInt(), this.readInt());
        }
        if (FileAttributes.Flag.MODE.isSet(mask)) {
            builder.withPermissions(this.readInt());
        }
        if (FileAttributes.Flag.ACMODTIME.isSet(mask)) {
            builder.withAtimeMtime(this.readInt(), this.readInt());
        }
        if (FileAttributes.Flag.EXTENDED.isSet(mask)) {
            int extCount = this.readInt();
            for (int i = 0; i < extCount; ++i) {
                builder.withExtended(this.readString(), this.readString());
            }
        }
        return builder.build();
    }

    public PacketType readType() {
        return PacketType.fromByte(this.readByte());
    }

    public T putFileAttributes(FileAttributes fa) {
        return (T)((SFTPPacket)this.putRawBytes(fa.toBytes()));
    }

    public T putType(PacketType type) {
        return (T)((SFTPPacket)this.putByte(type.toByte()));
    }
}

