/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.signature.Signature;

public abstract class AbstractSignature
implements Signature {
    protected java.security.Signature signature;
    protected String algorithm;

    protected AbstractSignature(String algorithm) {
        this.algorithm = algorithm;
    }

    public void init(PublicKey pubkey, PrivateKey prvkey) {
        try {
            this.signature = SecurityUtils.getSignature(this.algorithm);
            if (pubkey != null) {
                this.signature.initVerify(pubkey);
            }
            if (prvkey != null) {
                this.signature.initSign(prvkey);
            }
        }
        catch (GeneralSecurityException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public void update(byte[] foo) {
        this.update(foo, 0, foo.length);
    }

    public void update(byte[] foo, int off, int len) {
        try {
            this.signature.update(foo, off, len);
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
    }

    protected byte[] extractSig(byte[] sig) {
        if (sig[0] == 0 && sig[1] == 0 && sig[2] == 0) {
            int i = 0;
            int j = sig[i++] << 24 & 0xFF000000 | sig[i++] << 16 & 0xFF0000 | sig[i++] << 8 & 0xFF00 | sig[i++] & 0xFF;
            i += j;
            j = sig[i++] << 24 & 0xFF000000 | sig[i++] << 16 & 0xFF0000 | sig[i++] << 8 & 0xFF00 | sig[i++] & 0xFF;
            byte[] tmp = new byte[j];
            System.arraycopy(sig, i, tmp, 0, j);
            sig = tmp;
        }
        return sig;
    }
}

