/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Heartbeater
extends Thread {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TransportImpl trans;
    private int interval;
    private boolean started;

    Heartbeater(TransportImpl trans) {
        this.trans = trans;
        this.setName("heartbeater");
    }

    synchronized void setInterval(int interval) {
        this.interval = interval;
        if (interval != 0) {
            if (!this.started) {
                this.start();
            }
            this.notify();
        }
    }

    synchronized int getInterval() {
        return this.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    int hi;
                    Heartbeater heartbeater = this;
                    synchronized (heartbeater) {
                        while ((hi = this.interval) == 0) {
                            this.wait();
                        }
                    }
                    if (!this.started) {
                        this.started = true;
                    } else if (this.trans.isRunning()) {
                        this.log.info("Sending heartbeat since {} seconds elapsed", (Object)hi);
                        this.trans.write(new SSHPacket(Message.IGNORE));
                    }
                    Thread.sleep(hi * 1000);
                }
            }
            catch (Exception e) {
                if (Thread.currentThread().isInterrupted()) break block10;
                this.trans.die(e);
            }
        }
        this.log.debug("Stopping");
    }
}

