/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.cipher.Cipher;

public class BaseCipher
implements Cipher {
    private final int ivsize;
    private final int bsize;
    private final String algorithm;
    private final String transformation;
    private javax.crypto.Cipher cipher;

    private static byte[] resize(byte[] data, int size) {
        if (data.length > size) {
            byte[] tmp = new byte[size];
            System.arraycopy(data, 0, tmp, 0, size);
            data = tmp;
        }
        return data;
    }

    public BaseCipher(int ivsize, int bsize, String algorithm, String transformation) {
        this.ivsize = ivsize;
        this.bsize = bsize;
        this.algorithm = algorithm;
        this.transformation = transformation;
    }

    public int getBlockSize() {
        return this.bsize;
    }

    public int getIVSize() {
        return this.ivsize;
    }

    public void init(Cipher.Mode mode, byte[] key, byte[] iv) {
        key = BaseCipher.resize(key, this.bsize);
        iv = BaseCipher.resize(iv, this.ivsize);
        try {
            this.cipher = SecurityUtils.getCipher(this.transformation);
            this.cipher.init(mode == Cipher.Mode.Encrypt ? 1 : 2, (Key)new SecretKeySpec(key, this.algorithm), new IvParameterSpec(iv));
        }
        catch (GeneralSecurityException e) {
            this.cipher = null;
            throw new SSHRuntimeException(e);
        }
    }

    public void update(byte[] input, int inputOffset, int inputLen) {
        try {
            this.cipher.update(input, inputOffset, inputLen, input, inputOffset);
        }
        catch (ShortBufferException e) {
            throw new SSHRuntimeException(e);
        }
    }
}

