/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.compression;

import com.jcraft.jzlib.ZStream;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.compression.Compression;

public class ZlibCompression
implements Compression {
    private static final int BUF_SIZE = 4096;
    private ZStream stream;
    private final byte[] tmpbuf = new byte[4096];

    public void compress(SSHPacket buffer) {
        this.stream.next_in = buffer.array();
        this.stream.next_in_index = buffer.rpos();
        this.stream.avail_in = buffer.available();
        buffer.wpos(buffer.rpos());
        do {
            this.stream.next_out = this.tmpbuf;
            this.stream.next_out_index = 0;
            this.stream.avail_out = 4096;
            int status = this.stream.deflate(1);
            switch (status) {
                case 0: {
                    buffer.putRawBytes(this.tmpbuf, 0, 4096 - this.stream.avail_out);
                    break;
                }
                default: {
                    throw new SSHRuntimeException("compress: deflate returned " + status);
                }
            }
        } while (this.stream.avail_out == 0);
    }

    public void init(Compression.Type type, int level) {
        this.stream = new ZStream();
        if (type == Compression.Type.Deflater) {
            this.stream.deflateInit(level);
        } else {
            this.stream.inflateInit();
        }
    }

    public boolean isDelayed() {
        return false;
    }

    public void uncompress(SSHPacket from, SSHPacket to) throws TransportException {
        int status;
        this.stream.next_in = from.array();
        this.stream.next_in_index = from.rpos();
        this.stream.avail_in = from.available();
        block4: while (true) {
            this.stream.next_out = this.tmpbuf;
            this.stream.next_out_index = 0;
            this.stream.avail_out = 4096;
            status = this.stream.inflate(1);
            switch (status) {
                case 0: {
                    to.putRawBytes(this.tmpbuf, 0, 4096 - this.stream.avail_out);
                    continue block4;
                }
                case -5: {
                    return;
                }
            }
            break;
        }
        throw new TransportException(DisconnectReason.COMPRESSION_ERROR, "uncompress: inflate returned " + status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements Factory.Named<Compression> {
        @Override
        public Compression create() {
            return new ZlibCompression();
        }

        @Override
        public String getName() {
            return "zlib";
        }
    }
}

