/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;

public class DH {
    private BigInteger p;
    private BigInteger g;
    private BigInteger e;
    private byte[] e_array;
    private BigInteger f;
    private BigInteger K;
    private byte[] K_array;
    private final KeyPairGenerator myKpairGen;
    private final KeyAgreement myKeyAgree;

    public DH() {
        try {
            this.myKpairGen = SecurityUtils.getKeyPairGenerator("DH");
            this.myKeyAgree = SecurityUtils.getKeyAgreement("DH");
        }
        catch (GeneralSecurityException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public byte[] getE() {
        if (this.e == null) {
            KeyPair myKpair;
            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(this.p, this.g);
            try {
                this.myKpairGen.initialize(dhSkipParamSpec);
                myKpair = this.myKpairGen.generateKeyPair();
                this.myKeyAgree.init(myKpair.getPrivate());
            }
            catch (GeneralSecurityException e) {
                throw new SSHRuntimeException(e);
            }
            this.e = ((DHPublicKey)myKpair.getPublic()).getY();
            this.e_array = this.e.toByteArray();
        }
        return ByteArrayUtils.copyOf(this.e_array);
    }

    public byte[] getK() {
        if (this.K == null) {
            try {
                KeyFactory myKeyFac = SecurityUtils.getKeyFactory("DH");
                DHPublicKeySpec keySpec = new DHPublicKeySpec(this.f, this.p, this.g);
                PublicKey yourPubKey = myKeyFac.generatePublic(keySpec);
                this.myKeyAgree.doPhase(yourPubKey, true);
            }
            catch (GeneralSecurityException e) {
                throw new SSHRuntimeException(e);
            }
            byte[] mySharedSecret = this.myKeyAgree.generateSecret();
            this.K = new BigInteger(mySharedSecret);
            this.K_array = mySharedSecret;
        }
        return ByteArrayUtils.copyOf(this.K_array);
    }

    public void setF(byte[] f) {
        this.setF(new BigInteger(f));
    }

    public void setG(byte[] g) {
        this.setG(new BigInteger(g));
    }

    public void setP(byte[] p) {
        this.setP(new BigInteger(p));
    }

    void setF(BigInteger f) {
        this.f = f;
    }

    void setG(BigInteger g) {
        this.g = g;
    }

    void setP(BigInteger p) {
        this.p = p;
    }
}

