/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.schmizz.concurrent.Event;
import net.schmizz.sshj.AbstractService;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.AuthParams;
import net.schmizz.sshj.userauth.UserAuth;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AuthMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAuthImpl
extends AbstractService
implements UserAuth,
AuthParams {
    private final Set<String> allowed = new HashSet<String>();
    private final Deque<UserAuthException> savedEx = new ArrayDeque<UserAuthException>();
    private final Event<UserAuthException> result = new Event<UserAuthException>("userauth result", UserAuthException.chainer);
    private String username;
    private AuthMethod currentMethod;
    private Service nextService;
    private boolean firstAttempt = true;
    private volatile String banner;
    private volatile boolean partialSuccess;

    public UserAuthImpl(Transport trans) {
        super("ssh-userauth", trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void authenticate(String username, Service nextService, Iterable<AuthMethod> methods) throws UserAuthException, TransportException {
        this.clearState();
        this.username = username;
        this.nextService = nextService;
        this.request();
        if (this.firstAttempt) {
            for (AuthMethod meth : methods) {
                this.allowed.add(meth.getName());
            }
            this.firstAttempt = false;
        }
        try {
            for (AuthMethod meth : methods) {
                if (this.allowed.contains(meth.getName())) {
                    this.log.info("Trying `{}` auth...", (Object)meth.getName());
                    boolean success = false;
                    try {
                        success = this.tryWith(meth);
                    }
                    catch (UserAuthException e) {
                        this.saveException(e);
                    }
                    if (success) {
                        this.log.info("`{}` auth successful", (Object)meth.getName());
                        return;
                    }
                    this.log.info("`{}` auth failed", (Object)meth.getName());
                    continue;
                }
                this.saveException(meth.getName() + " auth not allowed by server");
            }
        }
        finally {
            this.currentMethod = null;
        }
        this.log.debug("Had {} saved exception(s)", (Object)this.savedEx.size());
        throw new UserAuthException("Exhausted available authentication methods", (Throwable)this.savedEx.peek());
    }

    @Override
    public String getBanner() {
        return this.banner;
    }

    @Override
    public String getNextServiceName() {
        return this.nextService.getName();
    }

    @Override
    public Transport getTransport() {
        return this.trans;
    }

    @Override
    public Deque<UserAuthException> getSavedExceptions() {
        return this.savedEx;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean hadPartialSuccess() {
        return this.partialSuccess;
    }

    @Override
    public void handle(Message msg, SSHPacket buf) throws SSHException {
        if (!msg.in(50, 80)) {
            throw new TransportException(DisconnectReason.PROTOCOL_ERROR);
        }
        switch (msg) {
            case USERAUTH_BANNER: {
                this.gotBanner(buf);
                break;
            }
            case USERAUTH_SUCCESS: {
                this.gotSuccess();
                break;
            }
            case USERAUTH_FAILURE: {
                this.gotFailure(buf);
                break;
            }
            default: {
                this.gotUnknown(msg, buf);
            }
        }
    }

    @Override
    public void notifyError(SSHException error) {
        super.notifyError(error);
        this.result.error(error);
    }

    private void clearState() {
        this.allowed.clear();
        this.savedEx.clear();
        this.banner = null;
    }

    private void gotBanner(SSHPacket buf) {
        this.banner = buf.readString();
    }

    private void gotFailure(SSHPacket buf) throws UserAuthException, TransportException {
        this.allowed.clear();
        this.allowed.addAll(Arrays.asList(buf.readString().split(",")));
        this.partialSuccess |= buf.readBoolean();
        if (this.allowed.contains(this.currentMethod.getName()) && this.currentMethod.shouldRetry()) {
            this.currentMethod.request();
        } else {
            this.saveException(this.currentMethod.getName() + " auth failed");
            this.result.set(false);
        }
    }

    private void gotSuccess() {
        this.trans.setAuthenticated();
        this.trans.setService(this.nextService);
        this.result.set(true);
    }

    private void gotUnknown(Message msg, SSHPacket buf) throws SSHException {
        if (this.currentMethod == null || this.result == null) {
            this.trans.sendUnimplemented();
            return;
        }
        this.log.debug("Asking {} method to handle {} packet", (Object)this.currentMethod.getName(), (Object)msg);
        try {
            this.currentMethod.handle(msg, buf);
        }
        catch (UserAuthException e) {
            this.result.error(e);
        }
    }

    private void saveException(String msg) {
        this.saveException(new UserAuthException(msg));
    }

    private void saveException(UserAuthException e) {
        this.log.error("Saving for later - {}", (Object)e.toString());
        this.savedEx.push(e);
    }

    private boolean tryWith(AuthMethod meth) throws UserAuthException, TransportException {
        this.currentMethod = meth;
        this.result.clear();
        meth.init(this);
        meth.request();
        return (Boolean)this.result.get(this.timeout, TimeUnit.SECONDS);
    }
}

