/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.AuthParams;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AuthMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthMethod
implements AuthMethod {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    protected AuthParams params;

    protected AbstractAuthMethod(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void handle(Message msg, SSHPacket buf) throws UserAuthException, TransportException {
        throw new UserAuthException("Unknown packet received during " + this.getName() + " auth: " + (Object)((Object)msg));
    }

    public void init(AuthParams params) {
        this.params = params;
    }

    public void request() throws UserAuthException, TransportException {
        this.params.getTransport().write(this.buildReq());
    }

    public boolean shouldRetry() {
        return false;
    }

    protected SSHPacket buildReq() throws UserAuthException {
        return (SSHPacket)((SSHPacket)((SSHPacket)new SSHPacket(Message.USERAUTH_REQUEST).putString(this.params.getUsername())).putString(this.params.getNextServiceName())).putString(this.name);
    }
}

