/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.AuthParams;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;
import net.schmizz.sshj.userauth.password.AccountResource;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;

public class AuthPassword
extends AbstractAuthMethod {
    private final PasswordFinder pwdf;
    private Resource resource;

    public AuthPassword(PasswordFinder pwdf) {
        super("password");
        this.pwdf = pwdf;
    }

    public void init(AuthParams params) {
        super.init(params);
        this.resource = new AccountResource(params.getUsername(), params.getTransport().getRemoteHost());
    }

    public SSHPacket buildReq() throws UserAuthException {
        this.log.info("Requesting password for " + this.resource);
        char[] password = this.pwdf.reqPassword(this.resource);
        if (password == null) {
            throw new UserAuthException("Was given null password for " + this.resource);
        }
        return (SSHPacket)((SSHPacket)super.buildReq().putBoolean(false)).putPassword(password);
    }

    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60) {
            throw new UserAuthException("Password change request received; unsupported operation");
        }
        super.handle(cmd, buf);
    }

    public boolean shouldRetry() {
        return this.pwdf.shouldRetry(this.resource);
    }
}

