/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import java.io.IOException;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.KeyedAuthMethod;

public class AuthPublickey
extends KeyedAuthMethod {
    public AuthPublickey(KeyProvider kProv) {
        super("publickey", kProv);
    }

    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60) {
            this.sendSignedReq();
        } else {
            super.handle(cmd, buf);
        }
    }

    private SSHPacket buildReq(boolean signed) throws UserAuthException {
        try {
            this.kProv.getPublic();
        }
        catch (IOException ioe) {
            throw new UserAuthException("Problem getting public key", (Throwable)ioe);
        }
        return this.putPubKey((SSHPacket)super.buildReq().putBoolean(signed));
    }

    private void sendSignedReq() throws UserAuthException, TransportException {
        this.log.debug("Sending signed request");
        this.params.getTransport().write(this.putSig(this.buildReq(true)));
    }

    protected SSHPacket buildReq() throws UserAuthException {
        return this.buildReq(false);
    }
}

