/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.signature.Signature;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;

public abstract class KeyedAuthMethod
extends AbstractAuthMethod {
    protected KeyProvider kProv;

    public KeyedAuthMethod(String name, KeyProvider kProv) {
        super(name);
        this.kProv = kProv;
    }

    protected SSHPacket putPubKey(SSHPacket reqBuf) throws UserAuthException {
        PublicKey key;
        try {
            key = this.kProv.getPublic();
        }
        catch (IOException ioe) {
            throw new UserAuthException("Problem getting public key", (Throwable)ioe);
        }
        ((SSHPacket)reqBuf.putString(KeyType.fromKey(key).toString())).putString(((Buffer.PlainBuffer)new Buffer.PlainBuffer().putPublicKey(key)).getCompactData());
        return reqBuf;
    }

    protected SSHPacket putSig(SSHPacket reqBuf) throws UserAuthException {
        PrivateKey key;
        try {
            key = this.kProv.getPrivate();
        }
        catch (IOException ioe) {
            throw new UserAuthException("Problem getting private key", (Throwable)ioe);
        }
        String kt = KeyType.fromKey(key).toString();
        Signature sigger = (Signature)Factory.Named.Util.create(this.params.getTransport().getConfig().getSignatureFactories(), kt);
        if (sigger == null) {
            throw new UserAuthException("Could not create signature instance for " + kt + " key");
        }
        sigger.init(null, key);
        sigger.update(((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.params.getTransport().getSessionID())).putBuffer(reqBuf)).getCompactData());
        reqBuf.putSignature(kt, sigger.sign());
        return reqBuf;
    }
}

