/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.xfer.FileTransferUtil;
import net.schmizz.sshj.xfer.ModeSetter;
import net.schmizz.sshj.xfer.scp.SCPEngine;
import net.schmizz.sshj.xfer.scp.SCPException;

public final class SCPDownloadClient
extends SCPEngine {
    private final ModeSetter modeSetter;
    private boolean recursive = true;

    SCPDownloadClient(SessionFactory host, ModeSetter modeSetter) {
        super(host);
        this.modeSetter = modeSetter;
    }

    public synchronized int copy(String sourcePath, String targetPath) throws IOException {
        return super.copy(sourcePath, targetPath);
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    void startCopy(String sourcePath, String targetPath) throws IOException {
        this.init(sourcePath);
        this.signal("Start status OK");
        String msg = this.readMessage(true);
        do {
            this.process(null, msg, new File(targetPath));
        } while ((msg = this.readMessage(false)) != null);
    }

    private void init(String source) throws SSHException {
        LinkedList<SCPEngine.Arg> args = new LinkedList<SCPEngine.Arg>();
        args.add(SCPEngine.Arg.SOURCE);
        args.add(SCPEngine.Arg.QUIET);
        if (this.recursive) {
            args.add(SCPEngine.Arg.RECURSIVE);
        }
        if (this.modeSetter.preservesTimes()) {
            args.add(SCPEngine.Arg.PRESERVE_TIMES);
        }
        this.execSCPWith(args, source);
    }

    private long parseLong(String longString, String valType) throws SCPException {
        try {
            return Long.parseLong(longString);
        }
        catch (NumberFormatException nfe) {
            throw new SCPException("Could not parse " + valType + " from `" + longString + "`", (Throwable)nfe);
        }
    }

    private int parsePermissions(String cmd) throws SCPException {
        if (cmd.length() != 5) {
            throw new SCPException("Could not parse permissions from `" + cmd + "`");
        }
        return Integer.parseInt(cmd.substring(1), 8);
    }

    private void prepare(File f, int perms, String tMsg) throws IOException {
        this.modeSetter.setPermissions(f, perms);
        if (tMsg != null && this.modeSetter.preservesTimes()) {
            String[] tMsgParts = this.tokenize(tMsg, 4);
            this.modeSetter.setLastModifiedTime(f, this.parseLong(tMsgParts[0].substring(1), "last modified time"));
            this.modeSetter.setLastAccessedTime(f, this.parseLong(tMsgParts[2], "last access time"));
        }
    }

    private boolean process(String bufferedTMsg, String msg, File f) throws IOException {
        if (msg.length() < 1) {
            throw new SCPException("Could not parse message `" + msg + "`");
        }
        switch (msg.charAt(0)) {
            case 'T': {
                this.signal("ACK: T");
                this.process(msg, this.readMessage(true), f);
                break;
            }
            case 'C': {
                this.processFile(msg, bufferedTMsg, f);
                break;
            }
            case 'D': {
                this.processDirectory(msg, bufferedTMsg, f);
                break;
            }
            case 'E': {
                return true;
            }
            case '\u0001': {
                this.addWarning(msg.substring(1));
                break;
            }
            case '\u0002': {
                throw new SCPException("Remote SCP command returned error: " + msg.substring(1));
            }
            default: {
                String err = "Unrecognized message: `" + msg + "`";
                this.sendMessage('\u0002' + err);
                throw new SCPException(err);
            }
        }
        return false;
    }

    private void processDirectory(String dMsg, String tMsg, File f) throws IOException {
        String[] dMsgParts = this.tokenize(dMsg, 3);
        long length = this.parseLong(dMsgParts[1], "dir length");
        if (length != 0L) {
            throw new IOException("Remote SCP command sent strange directory length: " + length);
        }
        f = FileTransferUtil.getTargetDirectory(f, dMsgParts[2]);
        this.prepare(f, this.parsePermissions(dMsgParts[0]), tMsg);
        this.signal("ACK: D");
        while (!this.process(null, this.readMessage(), f)) {
        }
        this.signal("ACK: E");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(String cMsg, String tMsg, File f) throws IOException {
        String[] cMsgParts = this.tokenize(cMsg, 3);
        long length = this.parseLong(cMsgParts[1], "length");
        f = FileTransferUtil.getTargetFile(f, cMsgParts[2]);
        this.prepare(f, this.parsePermissions(cMsgParts[0]), tMsg);
        this.signal("Remote can start transfer");
        FileOutputStream fos = new FileOutputStream(f);
        try {
            this.transfer(this.scp.getInputStream(), fos, this.scp.getLocalMaxPacketSize(), length);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(fos);
        this.check("Remote agrees transfer done");
        this.signal("Transfer done");
    }

    private String[] tokenize(String msg, int numPartsExpected) throws IOException {
        String[] parts = msg.split(" ");
        if (parts.length != numPartsExpected) {
            throw new IOException("Could not parse message received from remote SCP: " + msg);
        }
        return parts;
    }
}

