/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.util.Arrays;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Message;

public class SSHPacket
extends Buffer<SSHPacket> {
    public SSHPacket() {
    }

    public SSHPacket(int size) {
        super(size);
    }

    public SSHPacket(byte[] data) {
        super(data);
    }

    public SSHPacket(Message msg) {
        this.wpos = 5;
        this.rpos = 5;
        this.putMessageID(msg);
    }

    public SSHPacket(SSHPacket p) {
        this.data = Arrays.copyOf(p.data, p.wpos);
        this.rpos = p.rpos;
        this.wpos = p.wpos;
    }

    public Message readMessageID() {
        byte b = this.readByte();
        Message cmd = Message.fromByte(b);
        if (cmd == null) {
            throw new Buffer.BufferException("Unknown message ID: " + b);
        }
        return cmd;
    }

    public SSHPacket putMessageID(Message msg) {
        return (SSHPacket)this.putByte(msg.toByte());
    }
}

