/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.forwarded;

import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.forwarded.AbstractForwardedChannel;
import net.schmizz.sshj.connection.channel.forwarded.AbstractForwardedChannelOpener;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.transport.TransportException;

public class X11Forwarder
extends AbstractForwardedChannelOpener {
    private final ConnectListener listener;

    public X11Forwarder(Connection conn, ConnectListener listener) {
        super("x11", conn);
        this.listener = listener;
    }

    @Override
    public void handleOpen(SSHPacket buf) throws ConnectionException, TransportException {
        this.callListener(this.listener, new X11Channel(this.conn, buf.readInt(), buf.readInt(), buf.readInt(), buf.readString(), buf.readInt()));
    }

    public void stop() {
        this.conn.forget(this);
    }

    public static class X11Channel
    extends AbstractForwardedChannel {
        public static final String TYPE = "x11";

        public X11Channel(Connection conn, int recipient, int remoteWinSize, int remoteMaxPacketSize, String origIP, int origPort) {
            super(conn, TYPE, recipient, remoteWinSize, remoteMaxPacketSize, origIP, origPort);
        }
    }
}

