/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.SFTPEngine;

public class PathHelper {
    private final SFTPEngine sftp;
    private String dotDir;

    public PathHelper(SFTPEngine sftp) {
        this.sftp = sftp;
    }

    public PathComponents getComponents(String path) throws IOException {
        if (path.isEmpty() || path.equals(".")) {
            return this.getComponents(this.getDotDir());
        }
        int lastSlash = path.lastIndexOf("/");
        if (lastSlash == -1) {
            if (path.equals("..")) {
                return this.getComponents(this.canon(path));
            }
            return new PathComponents(this.getDotDir(), path);
        }
        String name = path.substring(lastSlash + 1);
        if (name.equals(".") || name.equals("..")) {
            return this.getComponents(this.canon(path));
        }
        String parent = path.substring(0, lastSlash);
        return new PathComponents(parent, name);
    }

    private synchronized String getDotDir() throws IOException {
        return this.dotDir != null ? this.dotDir : (this.dotDir = this.canon("."));
    }

    private String canon(String path) throws IOException {
        return this.sftp.canonicalize(path);
    }
}

