/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.PacketReader;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.Request;
import net.schmizz.sshj.sftp.Requester;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPEngine
implements Requester {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int PROTOCOL_VERSION = 3;
    public static final int DEFAULT_TIMEOUT = 30;
    private volatile int timeout = 30;
    private final Session.Subsystem sub;
    private final PacketReader reader;
    private final OutputStream out;
    private long reqID;
    private int negotiatedVersion;
    private final Map<String, String> serverExtensions = new HashMap<String, String>();

    public SFTPEngine(SessionFactory ssh) throws SSHException {
        this.sub = ssh.startSession().startSubsystem("sftp");
        this.out = this.sub.getOutputStream();
        this.reader = new PacketReader(this.sub.getInputStream());
    }

    public Session.Subsystem getSubsystem() {
        return this.sub;
    }

    public SFTPEngine init() throws IOException {
        this.transmit((SFTPPacket)new SFTPPacket(PacketType.INIT).putInt(3L));
        SFTPPacket<Response> response = this.reader.readPacket();
        PacketType type = response.readType();
        if (type != PacketType.VERSION) {
            throw new SFTPException("Expected INIT packet, received: " + (Object)((Object)type));
        }
        this.negotiatedVersion = response.readInt();
        this.log.info("Client version {}, server version {}", (Object)3, (Object)this.negotiatedVersion);
        if (this.negotiatedVersion < 3) {
            throw new SFTPException("Server reported protocol version: " + this.negotiatedVersion);
        }
        while (response.available() > 0) {
            this.serverExtensions.put(response.readString(), response.readString());
        }
        this.reader.start();
        return this;
    }

    public int getOperativeProtocolVersion() {
        return this.negotiatedVersion;
    }

    @Override
    public synchronized Request newRequest(PacketType type) {
        this.reqID = this.reqID + 1L & 0xFFFFFFFFL;
        return new Request(type, this.reqID);
    }

    @Override
    public Response doRequest(Request req) throws IOException {
        this.reader.expectResponseTo(req);
        this.log.debug("Sending {}", (Object)req);
        this.transmit(req);
        return req.getResponseFuture().get(this.timeout, TimeUnit.SECONDS);
    }

    private synchronized void transmit(SFTPPacket<Request> payload) throws IOException {
        int len = payload.available();
        this.out.write(len >>> 24 & 0xFF);
        this.out.write(len >>> 16 & 0xFF);
        this.out.write(len >>> 8 & 0xFF);
        this.out.write(len & 0xFF);
        this.out.write(payload.array(), payload.rpos(), len);
        this.out.flush();
    }

    public RemoteFile open(String path, Set<OpenMode> modes, FileAttributes fa) throws IOException {
        String handle = this.doRequest((Request)((Request)((Request)this.newRequest(PacketType.OPEN).putString(path)).putInt(OpenMode.toMask(modes))).putFileAttributes(fa)).ensurePacketTypeIs(PacketType.HANDLE).readString();
        return new RemoteFile(this, path, handle);
    }

    public RemoteFile open(String filename, Set<OpenMode> modes) throws IOException {
        return this.open(filename, modes, FileAttributes.EMPTY);
    }

    public RemoteFile open(String filename) throws IOException {
        return this.open(filename, EnumSet.of(OpenMode.READ));
    }

    public RemoteDirectory openDir(String path) throws IOException {
        String handle = this.doRequest((Request)this.newRequest(PacketType.OPENDIR).putString(path)).ensurePacketTypeIs(PacketType.HANDLE).readString();
        return new RemoteDirectory(this, path, handle);
    }

    public void setAttributes(String path, FileAttributes attrs) throws IOException {
        this.doRequest((Request)((Request)this.newRequest(PacketType.SETSTAT).putString(path)).putFileAttributes(attrs)).ensureStatusPacketIsOK();
    }

    public String readLink(String path) throws IOException {
        return SFTPEngine.readSingleName(this.doRequest((Request)this.newRequest(PacketType.READLINK).putString(path)));
    }

    public void makeDir(String path, FileAttributes attrs) throws IOException {
        this.doRequest((Request)((Request)this.newRequest(PacketType.MKDIR).putString(path)).putFileAttributes(attrs)).ensureStatusPacketIsOK();
    }

    public void makeDir(String path) throws IOException {
        this.makeDir(path, FileAttributes.EMPTY);
    }

    public void symlink(String linkpath, String targetpath) throws IOException {
        this.doRequest((Request)((Request)this.newRequest(PacketType.SYMLINK).putString(linkpath)).putString(targetpath)).ensureStatusPacketIsOK();
    }

    public void remove(String filename) throws IOException {
        this.doRequest((Request)this.newRequest(PacketType.REMOVE).putString(filename)).ensureStatusPacketIsOK();
    }

    public void removeDir(String path) throws IOException {
        this.doRequest((Request)this.newRequest(PacketType.RMDIR).putString(path)).ensureStatusIs(Response.StatusCode.OK);
    }

    private FileAttributes stat(PacketType pt, String path) throws IOException {
        return this.doRequest((Request)this.newRequest(pt).putString(path)).ensurePacketTypeIs(PacketType.ATTRS).readFileAttributes();
    }

    public FileAttributes stat(String path) throws IOException {
        return this.stat(PacketType.STAT, path);
    }

    public FileAttributes lstat(String path) throws IOException {
        return this.stat(PacketType.LSTAT, path);
    }

    public void rename(String oldPath, String newPath) throws IOException {
        this.doRequest((Request)((Request)this.newRequest(PacketType.RENAME).putString(oldPath)).putString(newPath)).ensureStatusPacketIsOK();
    }

    public String canonicalize(String path) throws IOException {
        return SFTPEngine.readSingleName(this.doRequest((Request)this.newRequest(PacketType.REALPATH).putString(path)));
    }

    private static String readSingleName(Response res) throws IOException {
        res.ensurePacketTypeIs(PacketType.NAME);
        if (res.readInt() == 1) {
            return res.readString();
        }
        throw new SFTPException("Unexpected data in " + (Object)((Object)res.getType()) + " packet");
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }
}

