/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.PathHelper;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.xfer.AbstractFileTransfer;
import net.schmizz.sshj.xfer.FileTransfer;
import net.schmizz.sshj.xfer.FileTransferUtil;
import net.schmizz.sshj.xfer.TransferListener;

public class SFTPFileTransfer
extends AbstractFileTransfer
implements FileTransfer {
    private final SFTPEngine sftp;
    private final PathHelper pathHelper;
    private volatile FileFilter uploadFilter = defaultLocalFilter;
    private volatile RemoteResourceFilter downloadFilter = defaultRemoteFilter;
    private static final FileFilter defaultLocalFilter = new FileFilter(){

        @Override
        public boolean accept(File pathName) {
            return true;
        }
    };
    private static final RemoteResourceFilter defaultRemoteFilter = new RemoteResourceFilter(){

        @Override
        public boolean accept(RemoteResourceInfo resource) {
            return true;
        }
    };

    public SFTPFileTransfer(SFTPEngine sftp) {
        this.sftp = sftp;
        this.pathHelper = new PathHelper(sftp);
    }

    @Override
    public void upload(String source, String dest) throws IOException {
        new Uploader().upload(new File(source), dest);
    }

    @Override
    public void download(String source, String dest) throws IOException {
        PathComponents pathComponents = this.pathHelper.getComponents(source);
        FileAttributes attributes = this.sftp.stat(source);
        new Downloader().download(new RemoteResourceInfo(pathComponents, attributes), new File(dest));
    }

    public void setUploadFilter(FileFilter uploadFilter) {
        this.uploadFilter = this.uploadFilter == null ? defaultLocalFilter : uploadFilter;
    }

    public void setDownloadFilter(RemoteResourceFilter downloadFilter) {
        this.downloadFilter = this.downloadFilter == null ? defaultRemoteFilter : downloadFilter;
    }

    public FileFilter getUploadFilter() {
        return this.uploadFilter;
    }

    public RemoteResourceFilter getDownloadFilter() {
        return this.downloadFilter;
    }

    private class Uploader {
        private final TransferListener listener;

        private Uploader() {
            this.listener = SFTPFileTransfer.this.getTransferListener();
        }

        private void upload(File local, String remote) throws IOException {
            String adjustedPath;
            if (local.isDirectory()) {
                this.listener.startedDir(local.getName());
                adjustedPath = this.uploadDir(local, remote);
                this.listener.finishedDir();
            } else if (local.isFile()) {
                this.listener.startedFile(local.getName(), local.length());
                adjustedPath = this.uploadFile(local, remote);
                this.listener.finishedFile();
            } else {
                throw new IOException(local + " is not a file or directory");
            }
            SFTPFileTransfer.this.sftp.setAttributes(adjustedPath, this.getAttributes(local));
        }

        private String uploadDir(File local, String remote) throws IOException {
            String adjusted = this.prepareDir(local, remote);
            for (File f : local.listFiles(SFTPFileTransfer.this.getUploadFilter())) {
                this.upload(f, adjusted);
            }
            return adjusted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String uploadFile(File local, String remote) throws IOException {
            String adjusted = this.prepareFile(local, remote);
            RemoteFile rf = SFTPFileTransfer.this.sftp.open(adjusted, EnumSet.of(OpenMode.WRITE, OpenMode.CREAT, OpenMode.TRUNC));
            try {
                FileInputStream fis = new FileInputStream(local);
                try {
                    int bufSize = SFTPFileTransfer.this.sftp.getSubsystem().getRemoteMaxPacketSize() - rf.getOutgoingPacketOverhead();
                    StreamCopier.copy(fis, rf.getOutputStream(), bufSize, false, this.listener);
                }
                finally {
                    fis.close();
                }
            }
            finally {
                rf.close();
            }
            return adjusted;
        }

        private String prepareDir(File local, String remote) throws IOException {
            FileAttributes attrs;
            try {
                attrs = SFTPFileTransfer.this.sftp.stat(remote);
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("probeDir: {} does not exist, creating", (Object)remote);
                    SFTPFileTransfer.this.sftp.makeDir(remote);
                    return remote;
                }
                throw e;
            }
            if (attrs.getMode().getType() == FileMode.Type.DIRECTORY) {
                if (SFTPFileTransfer.this.pathHelper.getComponents(remote).getName().equals(local.getName())) {
                    SFTPFileTransfer.this.log.debug("probeDir: {} already exists", (Object)remote);
                    return remote;
                }
                SFTPFileTransfer.this.log.debug("probeDir: {} already exists, path adjusted for {}", (Object)remote, (Object)local.getName());
                return this.prepareDir(local, PathComponents.adjustForParent(remote, local.getName()));
            }
            throw new IOException((Object)((Object)attrs.getMode().getType()) + " file already exists at " + remote);
        }

        private String prepareFile(File local, String remote) throws IOException {
            FileAttributes attrs;
            try {
                attrs = SFTPFileTransfer.this.sftp.stat(remote);
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("probeFile: {} does not exist", (Object)remote);
                    return remote;
                }
                throw e;
            }
            if (attrs.getMode().getType() == FileMode.Type.DIRECTORY) {
                SFTPFileTransfer.this.log.debug("probeFile: {} was directory, path adjusted for {}", (Object)remote, (Object)local.getName());
                remote = PathComponents.adjustForParent(remote, local.getName());
                return remote;
            }
            SFTPFileTransfer.this.log.debug("probeFile: {} is a {} file that will be replaced", (Object)remote, (Object)attrs.getMode().getType());
            return remote;
        }

        private FileAttributes getAttributes(File local) throws IOException {
            FileAttributes.Builder builder = new FileAttributes.Builder().withPermissions(SFTPFileTransfer.this.getModeGetter().getPermissions(local));
            if (SFTPFileTransfer.this.getModeGetter().preservesTimes()) {
                builder.withAtimeMtime(SFTPFileTransfer.this.getModeGetter().getLastAccessTime(local), SFTPFileTransfer.this.getModeGetter().getLastModifiedTime(local));
            }
            return builder.build();
        }
    }

    private class Downloader {
        private final TransferListener listener;

        private Downloader() {
            this.listener = SFTPFileTransfer.this.getTransferListener();
        }

        private void download(RemoteResourceInfo remote, File local) throws IOException {
            File adjustedFile;
            switch (remote.getAttributes().getType()) {
                case DIRECTORY: {
                    this.listener.startedDir(remote.getName());
                    adjustedFile = this.downloadDir(remote, local);
                    this.listener.finishedDir();
                    break;
                }
                case UNKNOWN: {
                    SFTPFileTransfer.this.log.warn("Server did not supply information about the type of file at `{}` -- assuming it is a regular file!", (Object)remote.getPath());
                }
                case REGULAR: {
                    this.listener.startedFile(remote.getName(), remote.getAttributes().getSize());
                    adjustedFile = this.downloadFile(remote, local);
                    this.listener.finishedFile();
                    break;
                }
                default: {
                    throw new IOException(remote + " is not a regular file or directory");
                }
            }
            this.copyAttributes(remote, adjustedFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File downloadDir(RemoteResourceInfo remote, File local) throws IOException {
            File adjusted = FileTransferUtil.getTargetDirectory(local, remote.getName());
            RemoteDirectory rd = SFTPFileTransfer.this.sftp.openDir(remote.getPath());
            try {
                for (RemoteResourceInfo rri : rd.scan(SFTPFileTransfer.this.getDownloadFilter())) {
                    this.download(rri, new File(adjusted.getPath(), rri.getName()));
                }
            }
            finally {
                rd.close();
            }
            return adjusted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File downloadFile(RemoteResourceInfo remote, File local) throws IOException {
            File adjusted = FileTransferUtil.getTargetFile(local, remote.getName());
            RemoteFile rf = SFTPFileTransfer.this.sftp.open(remote.getPath());
            try {
                FileOutputStream fos = new FileOutputStream(adjusted);
                try {
                    StreamCopier.copy(rf.getInputStream(), fos, SFTPFileTransfer.this.sftp.getSubsystem().getLocalMaxPacketSize(), false, this.listener);
                }
                finally {
                    fos.close();
                }
            }
            finally {
                rf.close();
            }
            return adjusted;
        }

        private void copyAttributes(RemoteResourceInfo remote, File local) throws IOException {
            FileAttributes attrs = remote.getAttributes();
            SFTPFileTransfer.this.getModeSetter().setPermissions(local, attrs.getMode().getPermissionsMask());
            if (SFTPFileTransfer.this.getModeSetter().preservesTimes() && attrs.has(FileAttributes.Flag.ACMODTIME)) {
                SFTPFileTransfer.this.getModeSetter().setLastAccessedTime(local, attrs.getAtime());
                SFTPFileTransfer.this.getModeSetter().setLastModifiedTime(local, attrs.getMtime());
            }
        }
    }
}

