/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import java.io.InputStream;
import net.schmizz.sshj.transport.Decoder;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.TransportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Reader
extends Thread {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TransportImpl trans;

    Reader(TransportImpl trans) {
        this.trans = trans;
        this.setName("reader");
    }

    @Override
    public void run() {
        block4: {
            Thread curThread = Thread.currentThread();
            try {
                Decoder decoder = this.trans.getDecoder();
                InputStream inp = this.trans.getConnInfo().in;
                byte[] recvbuf = new byte[decoder.getMaxPacketLength()];
                int needed = 1;
                while (!curThread.isInterrupted()) {
                    int read = inp.read(recvbuf, 0, needed);
                    if (read == -1) {
                        throw new TransportException("Broken transport; encountered EOF");
                    }
                    needed = decoder.received(recvbuf, read);
                }
            }
            catch (Exception e) {
                if (curThread.isInterrupted()) break block4;
                this.trans.die(e);
            }
        }
        this.log.debug("Stopping");
    }
}

