/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.signature.Signature;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.digest.Digest;
import net.schmizz.sshj.transport.digest.SHA1;
import net.schmizz.sshj.transport.kex.DH;
import net.schmizz.sshj.transport.kex.KeyExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDHG
implements KeyExchange {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Transport trans;
    private final Digest sha = new SHA1();
    private final DH dh = new DH();
    private byte[] V_S;
    private byte[] V_C;
    private byte[] I_S;
    private byte[] I_C;
    private byte[] e;
    private byte[] K;
    private byte[] H;
    private PublicKey hostKey;

    @Override
    public byte[] getH() {
        return ByteArrayUtils.copyOf(this.H);
    }

    @Override
    public byte[] getK() {
        return ByteArrayUtils.copyOf(this.K);
    }

    @Override
    public Digest getHash() {
        return this.sha;
    }

    @Override
    public PublicKey getHostKey() {
        return this.hostKey;
    }

    @Override
    public void init(Transport trans, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws GeneralSecurityException, TransportException {
        this.trans = trans;
        this.V_S = ByteArrayUtils.copyOf(V_S);
        this.V_C = ByteArrayUtils.copyOf(V_C);
        this.I_S = ByteArrayUtils.copyOf(I_S);
        this.I_C = ByteArrayUtils.copyOf(I_C);
        this.sha.init();
        this.initDH(this.dh);
        this.e = this.dh.getE();
        this.log.info("Sending SSH_MSG_KEXDH_INIT");
        trans.write((SSHPacket)new SSHPacket(Message.KEXDH_INIT).putMPInt(this.e));
    }

    @Override
    public boolean next(Message msg, SSHPacket packet) throws GeneralSecurityException, TransportException {
        if (msg != Message.KEXDH_31) {
            throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "Unexpected packet: " + (Object)((Object)msg));
        }
        this.log.info("Received SSH_MSG_KEXDH_REPLY");
        byte[] K_S = packet.readBytes();
        byte[] f = packet.readMPIntAsBytes();
        byte[] sig = packet.readBytes();
        this.dh.setF(new BigInteger(f));
        this.K = this.dh.getK();
        this.hostKey = new Buffer.PlainBuffer(K_S).readPublicKey();
        Buffer.PlainBuffer buf = (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.V_C)).putString(this.V_S)).putString(this.I_C)).putString(this.I_S)).putString(K_S)).putMPInt(this.e)).putMPInt(f)).putMPInt(this.K);
        this.sha.update(buf.array(), 0, buf.available());
        this.H = this.sha.digest();
        Signature signature = (Signature)Factory.Named.Util.create(this.trans.getConfig().getSignatureFactories(), KeyType.fromKey(this.hostKey).toString());
        signature.init(this.hostKey, null);
        signature.update(this.H, 0, this.H.length);
        if (!signature.verify(sig)) {
            throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "KeyExchange signature verification failed");
        }
        return true;
    }

    protected abstract void initDH(DH var1);
}

