/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.verification;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.transport.mac.HMACSHA1;
import net.schmizz.sshj.transport.mac.MAC;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSSHKnownHosts
implements HostKeyVerifier {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final File khFile;
    protected final List<Entry> entries = new ArrayList<Entry>();
    private static final String LS = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSSHKnownHosts(File khFile) throws IOException {
        this.khFile = khFile;
        if (khFile.exists()) {
            BufferedReader br = new BufferedReader(new FileReader(khFile));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    try {
                        this.entries.add(OpenSSHKnownHosts.isHashed(line) ? new HashedEntry(line) : new SimpleEntry(line));
                    }
                    catch (SSHException ignore) {
                        this.log.debug("Bad line ({}): {} ", (Object)ignore.toString(), (Object)line);
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
            IOUtils.closeQuietly(br);
        }
    }

    public File getFile() {
        return this.khFile;
    }

    @Override
    public boolean verify(String hostname, int port, PublicKey key) {
        KeyType type = KeyType.fromKey(key);
        if (type == KeyType.UNKNOWN) {
            return false;
        }
        String adjustedHostname = port != 22 ? "[" + hostname + "]:" + port : hostname;
        for (Entry e : this.entries) {
            try {
                if (e.getType() != type || !e.appliesTo(adjustedHostname)) continue;
                return key.equals(e.getKey()) || this.hostKeyChangedAction(e, adjustedHostname, key);
            }
            catch (IOException ioe) {
                this.log.error("Error with {}: {}", (Object)e, (Object)ioe);
                return false;
            }
        }
        return this.hostKeyUnverifiableAction(adjustedHostname, key);
    }

    protected boolean hostKeyUnverifiableAction(String hostname, PublicKey key) {
        return false;
    }

    protected boolean hostKeyChangedAction(Entry entry, String hostname, PublicKey key) {
        this.log.warn("Host key for `{}` has changed!", (Object)hostname);
        return false;
    }

    public List<Entry> entries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.khFile));
        try {
            for (Entry entry : this.entries) {
                bos.write((entry.getLine() + LS).getBytes());
            }
        }
        finally {
            bos.close();
        }
    }

    public static File detectSSHDir() {
        File sshDir = new File(System.getProperty("user.home"), ".ssh");
        return sshDir.exists() ? sshDir : null;
    }

    public static boolean isHashed(String line) {
        return line.startsWith("|1|");
    }

    public static class HashedEntry
    extends Entry {
        private final MAC sha1 = new HMACSHA1();
        private String salt;
        private byte[] saltyBytes;
        private final String hashedHost;

        public HashedEntry(String host, PublicKey key) throws IOException {
            this.saltyBytes = new byte[this.sha1.getBlockSize()];
            new Random().nextBytes(this.saltyBytes);
            this.hashedHost = this.hashHost(host);
            this.init(key);
        }

        public HashedEntry(String line) throws IOException {
            String[] parts = line.split(" ");
            if (parts.length != 3) {
                throw new SSHException("Line parts not 3: " + line);
            }
            this.hashedHost = parts[0];
            String[] hostParts = this.hashedHost.split("\\|");
            if (hostParts.length != 4) {
                throw new SSHException("Unrecognized format for hashed hostname");
            }
            this.salt = hostParts[2];
            this.init(parts[1], parts[2]);
        }

        @Override
        public boolean appliesTo(String host) throws IOException {
            return this.hashedHost.equals(this.hashHost(host));
        }

        private String hashHost(String host) throws IOException {
            this.sha1.init(this.getSaltyBytes());
            return "|1|" + this.getSalt() + "|" + Base64.encodeBytes(this.sha1.doFinal(host.getBytes()));
        }

        private byte[] getSaltyBytes() throws IOException {
            if (this.saltyBytes == null) {
                this.saltyBytes = Base64.decode(this.salt);
            }
            return this.saltyBytes;
        }

        private String getSalt() {
            if (this.salt == null) {
                this.salt = Base64.encodeBytes(this.saltyBytes);
            }
            return this.salt;
        }

        @Override
        protected String getHostPart() {
            return this.hashedHost;
        }
    }

    public static class SimpleEntry
    extends Entry {
        private final List<String> hosts;

        public SimpleEntry(String host, PublicKey key) throws SSHException {
            this(Arrays.asList(host), key);
        }

        public SimpleEntry(List<String> hosts, PublicKey key) throws SSHException {
            this.hosts = hosts;
            this.init(key);
        }

        public SimpleEntry(String line) throws SSHException {
            String[] parts = line.split(" ");
            if (parts.length != 3) {
                throw new SSHException("Line parts not 3: " + line);
            }
            this.hosts = Arrays.asList(parts[0].split(","));
            this.init(parts[1], parts[2]);
        }

        @Override
        public boolean appliesTo(String host) {
            for (String h : this.hosts) {
                if (!host.equals(h)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected String getHostPart() {
            StringBuilder sb = new StringBuilder();
            for (String host : this.hosts) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(host);
            }
            return sb.toString();
        }
    }

    public static abstract class Entry {
        private KeyType type;
        private PublicKey key;
        private String sKey;

        protected void init(PublicKey key) throws SSHException {
            this.key = key;
            this.type = KeyType.fromKey(key);
            if (this.type == KeyType.UNKNOWN) {
                throw new SSHException("Unknown key type for key: " + key);
            }
        }

        protected void init(String typeString, String keyString) throws SSHException {
            this.sKey = keyString;
            this.type = KeyType.fromString(typeString);
            if (this.type == KeyType.UNKNOWN) {
                throw new SSHException("Unknown key type: " + typeString);
            }
        }

        public KeyType getType() {
            return this.type;
        }

        public PublicKey getKey() throws IOException {
            if (this.key == null) {
                this.key = new Buffer.PlainBuffer(Base64.decode(this.sKey)).readPublicKey();
            }
            return this.key;
        }

        protected String getKeyString() {
            if (this.sKey == null) {
                Buffer.PlainBuffer buf = (Buffer.PlainBuffer)new Buffer.PlainBuffer().putPublicKey(this.key);
                this.sKey = Base64.encodeBytes(buf.array(), buf.rpos(), buf.available());
            }
            return this.sKey;
        }

        public String getLine() {
            StringBuilder line = new StringBuilder();
            line.append(this.getHostPart());
            line.append(" ").append(this.type.toString());
            line.append(" ").append(this.getKeyString());
            return line.toString();
        }

        public String toString() {
            return "KnownHostsEntry{host=" + this.getHostPart() + "; type=" + (Object)((Object)this.type) + "}";
        }

        protected abstract String getHostPart();

        public abstract boolean appliesTo(String var1) throws IOException;
    }
}

