/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import net.schmizz.sshj.userauth.password.PrivateKeyFileResource;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS8KeyFile
implements FileKeyProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected PasswordFinder pwdf;
    protected PrivateKeyFileResource resource;
    protected KeyPair kp;
    protected KeyType type;
    protected char[] passphrase;

    @Override
    public PrivateKey getPrivate() throws IOException {
        PrivateKey privateKey;
        if (this.kp != null) {
            privateKey = this.kp.getPrivate();
        } else {
            this.kp = this.readKeyPair();
            privateKey = this.kp.getPrivate();
        }
        return privateKey;
    }

    @Override
    public PublicKey getPublic() throws IOException {
        PublicKey publicKey;
        if (this.kp != null) {
            publicKey = this.kp.getPublic();
        } else {
            this.kp = this.readKeyPair();
            publicKey = this.kp.getPublic();
        }
        return publicKey;
    }

    @Override
    public KeyType getType() throws IOException {
        return this.type != null ? this.type : (this.type = KeyType.fromKey(this.getPublic()));
    }

    @Override
    public void init(File location) {
        assert (location != null);
        this.resource = new PrivateKeyFileResource(location.getAbsoluteFile());
    }

    @Override
    public void init(File location, PasswordFinder pwdf) {
        this.init(location);
        this.pwdf = pwdf;
    }

    protected org.bouncycastle.openssl.PasswordFinder makeBouncyPasswordFinder() {
        if (this.pwdf == null) {
            return null;
        }
        return new org.bouncycastle.openssl.PasswordFinder(){

            public char[] getPassword() {
                PKCS8KeyFile.this.passphrase = PKCS8KeyFile.this.pwdf.reqPassword(PKCS8KeyFile.this.resource);
                return PKCS8KeyFile.this.passphrase;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyPair readKeyPair() throws IOException {
        KeyPair kp = null;
        org.bouncycastle.openssl.PasswordFinder pFinder = this.makeBouncyPasswordFinder();
        PEMReader r = null;
        Object o = null;
        try {
            while (true) {
                try {
                    r = new PEMReader((Reader)new InputStreamReader(new FileInputStream((File)this.resource.getDetail())), pFinder);
                    o = r.readObject();
                }
                catch (EncryptionException e) {
                    block13: {
                        try {
                            if (!this.pwdf.shouldRetry(this.resource)) break block13;
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(new Closeable[]{r});
                            throw throwable;
                        }
                        IOUtils.closeQuietly(new Closeable[]{r});
                        continue;
                    }
                    throw e;
                }
                IOUtils.closeQuietly(new Closeable[]{r});
                break;
            }
        }
        finally {
            PasswordUtils.blankOut(this.passphrase);
        }
        if (o == null) {
            throw new IOException("Could not read key pair from: " + this.resource);
        }
        if (o instanceof KeyPair) {
            kp = (KeyPair)o;
        } else {
            this.log.debug("Expected KeyPair, got {}", o);
        }
        return kp;
    }

    public String toString() {
        return "PKCS8KeyFile{resource=" + this.resource + "}";
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new PKCS8KeyFile();
        }

        @Override
        public String getName() {
            return "PKCS8";
        }
    }
}

