/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.schmizz.concurrent.ExceptionChainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Future<V, T extends Throwable> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final ExceptionChainer<T> chainer;
    private final ReentrantLock lock;
    private final Condition cond;
    private V val;
    private T pendingEx;

    public Future(String name, ExceptionChainer<T> chainer) {
        this(name, chainer, null);
    }

    public Future(String name, ExceptionChainer<T> chainer, ReentrantLock lock) {
        this.name = name;
        this.chainer = chainer;
        this.lock = lock == null ? new ReentrantLock() : lock;
        this.cond = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(V val) {
        this.lock();
        try {
            this.log.debug("Setting <<{}>> to `{}`", (Object)this.name, val);
            this.val = val;
            this.cond.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Throwable e) {
        this.lock();
        try {
            this.pendingEx = this.chainer.chain(e);
            this.cond.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock();
        try {
            this.pendingEx = null;
            this.set(null);
        }
        finally {
            this.unlock();
        }
    }

    public V get() throws T {
        return this.get(0L, TimeUnit.SECONDS);
    }

    public V get(long timeout, TimeUnit unit) throws T {
        this.lock();
        try {
            if (this.pendingEx != null) {
                throw this.pendingEx;
            }
            if (this.val != null) {
                V v = this.val;
                return v;
            }
            this.log.debug("Awaiting <<{}>>", (Object)this.name);
            while (this.val == null && this.pendingEx == null) {
                if (timeout == 0L) {
                    this.cond.await();
                    continue;
                }
                if (this.cond.await(timeout, unit)) continue;
                throw this.chainer.chain(new TimeoutException("Timeout expired"));
            }
            if (this.pendingEx != null) {
                this.log.error("<<{}>> woke to: {}", (Object)this.name, (Object)((Throwable)this.pendingEx).toString());
                throw this.pendingEx;
            }
            V v = this.val;
            return v;
        }
        catch (InterruptedException ie) {
            throw this.chainer.chain(ie);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSet() {
        this.lock();
        try {
            boolean bl = this.pendingEx == null && this.val != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasError() {
        this.lock();
        try {
            boolean bl = this.pendingEx != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWaiters() {
        this.lock();
        try {
            boolean bl = this.lock.hasWaiters(this.cond);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }
}

