/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCopier
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(StreamCopier.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InputStream in;
    private final OutputStream out;
    private int bufSize = 1;
    private boolean keepFlushing = true;
    private ErrorCallback errCB = new ErrorCallback(){

        @Override
        public void onError(IOException ioe) {
        }
    };

    public static ErrorCallback closeOnErrorCallback(final Closeable ... toClose) {
        return new ErrorCallback(){

            @Override
            public void onError(IOException ioe) {
                IOUtils.closeQuietly(toClose);
            }
        };
    }

    public static long copy(InputStream in, OutputStream out, int bufSize, boolean keepFlushing, Listener listener) throws IOException {
        int read;
        long count = 0L;
        boolean reportProgress = listener != null;
        long startTime = System.currentTimeMillis();
        byte[] buf = new byte[bufSize];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
            count += (long)read;
            if (keepFlushing) {
                out.flush();
            }
            if (!reportProgress) continue;
            listener.reportProgress(count);
        }
        if (!keepFlushing) {
            out.flush();
        }
        double sizeKiB = (double)count / 1024.0;
        double timeSeconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        LOG.info(sizeKiB + " KiB transferred  in {} seconds ({} KiB/s)", (Object)timeSeconds, (Object)(sizeKiB / timeSeconds));
        return count;
    }

    public static long copy(InputStream in, OutputStream out, int bufSize, boolean keepFlushing) throws IOException {
        return StreamCopier.copy(in, out, bufSize, keepFlushing, null);
    }

    public static String copyStreamToString(InputStream stream) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder();
        while ((read = stream.read()) != -1) {
            sb.append((char)read);
        }
        return sb.toString();
    }

    public StreamCopier(String name, InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.setName(name);
    }

    public StreamCopier bufSize(int size) {
        this.bufSize = size;
        return this;
    }

    public StreamCopier keepFlushing(boolean choice) {
        this.keepFlushing = choice;
        return this;
    }

    public StreamCopier daemon(boolean choice) {
        this.setDaemon(choice);
        return this;
    }

    public StreamCopier errorCallback(ErrorCallback errCB) {
        this.errCB = errCB;
        return this;
    }

    @Override
    public void run() {
        try {
            this.log.debug("Wil pipe from {} to {}", (Object)this.in, (Object)this.out);
            StreamCopier.copy(this.in, this.out, this.bufSize, this.keepFlushing);
            this.log.debug("EOF on {}", (Object)this.in);
        }
        catch (IOException ioe) {
            this.log.error("In pipe from {} to {}: " + ioe.toString(), (Object)this.in, (Object)this.out);
            this.errCB.onError(ioe);
        }
    }

    public static interface Listener {
        public void reportProgress(long var1);
    }

    public static interface ErrorCallback {
        public void onError(IOException var1);
    }
}

