/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.schmizz.concurrent.Event;
import net.schmizz.concurrent.FutureUtils;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.ChannelInputStream;
import net.schmizz.sshj.connection.channel.ChannelOutputStream;
import net.schmizz.sshj.connection.channel.Window;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannel
implements Channel {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Transport trans;
    protected final Connection conn;
    private final String type;
    private final int id;
    private int recipient;
    private final Queue<Event<ConnectionException>> chanReqResponseEvents = new LinkedList<Event<ConnectionException>>();
    private final ReentrantLock lock = new ReentrantLock();
    protected final Event<ConnectionException> open;
    protected final Event<ConnectionException> close;
    private boolean eofSent;
    private boolean eofGot;
    private boolean closeRequested;
    protected final Window.Local lwin;
    private final ChannelInputStream in;
    protected Window.Remote rwin;
    private ChannelOutputStream out;
    private volatile boolean autoExpand = false;

    protected AbstractChannel(Connection conn, String type) {
        this.conn = conn;
        this.type = type;
        this.trans = conn.getTransport();
        this.id = conn.nextID();
        this.lwin = new Window.Local(conn.getWindowSize(), conn.getMaxPacketSize());
        this.in = new ChannelInputStream(this, this.trans, this.lwin);
        this.open = new Event<ConnectionException>("chan#" + this.id + " / " + "open", ConnectionException.chainer, this.lock);
        this.close = new Event<ConnectionException>("chan#" + this.id + " / " + "close", ConnectionException.chainer, this.lock);
    }

    protected void init(int recipient, int remoteWinSize, int remoteMaxPacketSize) {
        this.recipient = recipient;
        this.rwin = new Window.Remote(remoteWinSize, remoteMaxPacketSize);
        this.out = new ChannelOutputStream(this, this.trans, this.rwin);
        this.log.info("Initialized - {}", (Object)this);
    }

    @Override
    public boolean getAutoExpand() {
        return this.autoExpand;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public int getLocalMaxPacketSize() {
        return this.lwin.getMaxPacketSize();
    }

    @Override
    public int getLocalWinSize() {
        return this.lwin.getSize();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public int getRecipient() {
        return this.recipient;
    }

    @Override
    public int getRemoteMaxPacketSize() {
        return this.rwin.getMaxPacketSize();
    }

    @Override
    public int getRemoteWinSize() {
        return this.rwin.getSize();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void handle(Message msg, SSHPacket buf) throws ConnectionException, TransportException {
        switch (msg) {
            case CHANNEL_DATA: {
                this.receiveInto(this.in, buf);
                break;
            }
            case CHANNEL_EXTENDED_DATA: {
                this.gotExtendedData(buf.readInt(), buf);
                break;
            }
            case CHANNEL_WINDOW_ADJUST: {
                this.gotWindowAdjustment(buf.readInt());
                break;
            }
            case CHANNEL_REQUEST: {
                this.gotChannelRequest(buf);
                break;
            }
            case CHANNEL_SUCCESS: {
                this.gotResponse(true);
                break;
            }
            case CHANNEL_FAILURE: {
                this.gotResponse(false);
                break;
            }
            case CHANNEL_EOF: {
                this.gotEOF();
                break;
            }
            case CHANNEL_CLOSE: {
                this.gotClose();
                break;
            }
            default: {
                this.gotUnknown(msg, buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotClose() throws TransportException {
        this.log.info("Got close");
        try {
            this.closeAllStreams();
            this.sendClose();
        }
        finally {
            this.finishOff();
        }
    }

    protected void closeAllStreams() {
        IOUtils.closeQuietly(this.in, this.out);
    }

    @Override
    public void notifyError(SSHException error) {
        this.log.debug("Channel #{} got notified of {}", (Object)this.getID(), (Object)error.toString());
        FutureUtils.alertAll((Throwable)error, this.open, this.close);
        FutureUtils.alertAll((Throwable)error, this.chanReqResponseEvents);
        this.in.notifyError(error);
        this.out.notifyError(error);
        this.finishOff();
    }

    @Override
    public void setAutoExpand(boolean autoExpand) {
        this.autoExpand = autoExpand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ConnectionException, TransportException {
        this.lock.lock();
        try {
            block5: {
                try {
                    this.sendClose();
                }
                catch (TransportException e) {
                    if (this.close.hasError()) break block5;
                    throw e;
                }
            }
            this.close.await(this.conn.getTimeout(), TimeUnit.SECONDS);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void join() throws ConnectionException {
        this.close.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sendClose() throws TransportException {
        try {
            if (!this.closeRequested) {
                this.log.info("Sending close");
                this.trans.write(this.newBuffer(Message.CHANNEL_CLOSE));
            }
        }
        finally {
            this.closeRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isOpen() {
        this.lock.lock();
        try {
            boolean bl = this.open.isSet() && !this.close.isSet() && !this.closeRequested;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void gotChannelRequest(SSHPacket buf) throws ConnectionException, TransportException {
        String reqType = buf.readString();
        buf.readBoolean();
        this.log.info("Got chan request for `{}`", (Object)reqType);
        this.handleRequest(reqType, buf);
    }

    private void gotWindowAdjustment(int howMuch) {
        this.log.info("Received window adjustment for {} bytes", (Object)howMuch);
        this.rwin.expand(howMuch);
    }

    protected void finishOff() {
        this.conn.forget(this);
        this.close.set();
    }

    protected void gotExtendedData(int dataTypeCode, SSHPacket buf) throws ConnectionException, TransportException {
        throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Extended data not supported on " + this.type + " channel");
    }

    protected void gotUnknown(Message msg, SSHPacket buf) throws ConnectionException, TransportException {
    }

    protected void handleRequest(String reqType, SSHPacket buf) throws ConnectionException, TransportException {
        this.trans.write(this.newBuffer(Message.CHANNEL_FAILURE));
    }

    protected SSHPacket newBuffer(Message cmd) {
        return (SSHPacket)new SSHPacket(cmd).putInt(this.recipient);
    }

    protected void receiveInto(ChannelInputStream stream, SSHPacket buf) throws ConnectionException, TransportException {
        int len = buf.readInt();
        if (len < 0 || len > this.getLocalMaxPacketSize() || len > buf.available()) {
            throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Bad item length: " + len);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("IN #{}: {}", (Object)this.id, (Object)ByteArrayUtils.printHex(buf.array(), buf.rpos(), len));
        }
        stream.receive(buf.array(), buf.rpos(), len);
    }

    protected synchronized Event<ConnectionException> sendChannelRequest(String reqType, boolean wantReply, Buffer.PlainBuffer reqSpecific) throws TransportException {
        this.log.info("Sending channel request for `{}`", (Object)reqType);
        this.trans.write((SSHPacket)((SSHPacket)((SSHPacket)this.newBuffer(Message.CHANNEL_REQUEST).putString(reqType)).putBoolean(wantReply)).putBuffer(reqSpecific));
        Event<ConnectionException> responseEvent = null;
        if (wantReply) {
            responseEvent = new Event<ConnectionException>("chan#" + this.id + " / " + "chanreq for " + reqType, ConnectionException.chainer, this.lock);
            this.chanReqResponseEvents.add(responseEvent);
        }
        return responseEvent;
    }

    private synchronized void gotResponse(boolean success) throws ConnectionException {
        Event<ConnectionException> responseEvent = this.chanReqResponseEvents.poll();
        if (responseEvent != null) {
            if (success) {
                responseEvent.set();
            } else {
                responseEvent.error(new ConnectionException("Request failed"));
            }
        } else {
            throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Received response to channel request when none was requested");
        }
    }

    private synchronized void gotEOF() throws TransportException {
        this.log.info("Got EOF");
        this.eofGot = true;
        this.eofInputStreams();
        if (this.eofSent) {
            this.sendClose();
        }
    }

    protected void eofInputStreams() {
        this.in.eof();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendEOF() throws TransportException {
        try {
            if (!this.closeRequested && !this.eofSent) {
                this.log.info("Sending EOF");
                this.trans.write(this.newBuffer(Message.CHANNEL_EOF));
                if (this.eofGot) {
                    this.sendClose();
                }
            }
        }
        finally {
            this.eofSent = true;
            this.out.setClosed();
        }
    }

    public String toString() {
        return "< " + this.type + " channel: id=" + this.id + ", recipient=" + this.recipient + ", localWin=" + this.lwin + ", remoteWin=" + this.rwin + " >";
    }
}

