/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.schmizz.concurrent.Event;
import net.schmizz.concurrent.FutureUtils;
import net.schmizz.sshj.AbstractService;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.Decoder;
import net.schmizz.sshj.transport.Encoder;
import net.schmizz.sshj.transport.Heartbeater;
import net.schmizz.sshj.transport.KeyExchanger;
import net.schmizz.sshj.transport.Reader;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportImpl
implements Transport {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Service nullService = new NullService(this);
    private final Config config;
    private final KeyExchanger kexer;
    private final Reader reader;
    private final Heartbeater heartbeater;
    private final Encoder encoder;
    private final Decoder decoder;
    private final Event<TransportException> serviceAccept = new Event<TransportException>("service accept", TransportException.chainer);
    private final Event<TransportException> close = new Event<TransportException>("transport close", TransportException.chainer);
    private final String clientID;
    private volatile int timeout = 30;
    private volatile boolean authed = false;
    private volatile Service service = this.nullService;
    private ConnInfo connInfo;
    private String serverID;
    private Message msg;
    private final ReentrantLock writeLock = new ReentrantLock();

    public TransportImpl(Config config) {
        this.config = config;
        this.reader = new Reader(this);
        this.heartbeater = new Heartbeater(this);
        this.encoder = new Encoder(config.getRandomFactory().create(), this.writeLock);
        this.decoder = new Decoder(this);
        this.kexer = new KeyExchanger(this);
        this.clientID = "SSH-2.0-" + config.getVersion();
    }

    @Override
    public void init(String remoteHost, int remotePort, InputStream in, OutputStream out) throws TransportException {
        this.connInfo = new ConnInfo(remoteHost, remotePort, in, out);
        try {
            this.log.info("Client identity string: {}", (Object)this.clientID);
            this.connInfo.out.write((this.clientID + "\r\n").getBytes());
            Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
            while ((this.serverID = this.readIdentification(buf)).isEmpty()) {
                buf.putByte((byte)this.connInfo.in.read());
            }
            this.log.info("Server identity string: {}", (Object)this.serverID);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        this.reader.start();
    }

    private String readIdentification(Buffer.PlainBuffer buffer) throws IOException {
        String ident;
        block7: {
            byte[] data = new byte[256];
            do {
                int savedBufPos = buffer.rpos();
                int pos = 0;
                boolean needLF = false;
                while (true) {
                    if (buffer.available() == 0) {
                        buffer.rpos(savedBufPos);
                        return "";
                    }
                    byte b = buffer.readByte();
                    if (b == 13) {
                        needLF = true;
                        continue;
                    }
                    if (b == 10) break;
                    if (needLF) {
                        throw new TransportException("Incorrect identification: bad line ending");
                    }
                    if (pos >= data.length) {
                        throw new TransportException("Incorrect identification: line too long");
                    }
                    data[pos++] = b;
                }
                ident = new String(data, 0, pos);
                if (ident.startsWith("SSH-")) break block7;
            } while (buffer.rpos() <= 16384);
            throw new TransportException("Incorrect identification: too many header lines");
        }
        if (!ident.startsWith("SSH-2.0-") && !ident.startsWith("SSH-1.99-")) {
            throw new TransportException(DisconnectReason.PROTOCOL_VERSION_NOT_SUPPORTED, "Server does not support SSHv2, identified as: " + ident);
        }
        return ident;
    }

    @Override
    public void addHostKeyVerifier(HostKeyVerifier hkv) {
        this.kexer.addHostKeyVerifier(hkv);
    }

    @Override
    public void doKex() throws TransportException {
        this.kexer.startKex(true);
    }

    public boolean isKexDone() {
        return this.kexer.isKexDone();
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public int getHeartbeatInterval() {
        return this.heartbeater.getInterval();
    }

    @Override
    public void setHeartbeatInterval(int interval) {
        this.heartbeater.setInterval(interval);
    }

    @Override
    public String getRemoteHost() {
        return this.connInfo.host;
    }

    @Override
    public int getRemotePort() {
        return this.connInfo.port;
    }

    @Override
    public String getClientVersion() {
        return this.clientID.substring(8);
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public String getServerVersion() {
        return this.serverID == null ? this.serverID : this.serverID.substring(8);
    }

    @Override
    public byte[] getSessionID() {
        return this.kexer.getSessionID();
    }

    @Override
    public synchronized Service getService() {
        return this.service;
    }

    @Override
    public synchronized void setService(Service service) {
        if (service == null) {
            service = this.nullService;
        }
        this.log.info("Setting active service to {}", (Object)service.getName());
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reqService(Service service) throws TransportException {
        this.serviceAccept.lock();
        try {
            this.serviceAccept.clear();
            this.sendServiceRequest(service.getName());
            this.serviceAccept.await(this.timeout, TimeUnit.SECONDS);
            this.setService(service);
        }
        finally {
            this.serviceAccept.unlock();
        }
    }

    private void sendServiceRequest(String serviceName) throws TransportException {
        this.log.debug("Sending SSH_MSG_SERVICE_REQUEST for {}", (Object)serviceName);
        this.write((SSHPacket)new SSHPacket(Message.SERVICE_REQUEST).putString(serviceName));
    }

    @Override
    public void setAuthenticated() {
        this.authed = true;
        this.encoder.setAuthenticated();
        this.decoder.setAuthenticated();
    }

    @Override
    public boolean isAuthenticated() {
        return this.authed;
    }

    @Override
    public long sendUnimplemented() throws TransportException {
        long seq = this.decoder.getSequenceNumber();
        this.log.info("Sending SSH_MSG_UNIMPLEMENTED for packet #{}", (Object)seq);
        return this.write((SSHPacket)new SSHPacket(Message.UNIMPLEMENTED).putInt(seq));
    }

    @Override
    public void join() throws TransportException {
        this.close.await();
    }

    @Override
    public boolean isRunning() {
        return this.reader.isAlive() && !this.close.isSet();
    }

    @Override
    public void disconnect() {
        this.disconnect(DisconnectReason.BY_APPLICATION);
    }

    @Override
    public void disconnect(DisconnectReason reason) {
        this.disconnect(reason, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(DisconnectReason reason, String message) {
        this.close.lock();
        try {
            try {
                this.service.notifyDisconnect();
            }
            catch (SSHException logged) {
                this.log.warn("{} did not handle disconnect cleanly: {}", (Object)this.service, (Object)logged);
            }
            if (!this.close.isSet()) {
                this.sendDisconnect(reason, message);
                this.finishOff();
                this.close.set();
            }
        }
        finally {
            this.close.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(SSHPacket payload) throws TransportException {
        this.writeLock.lock();
        try {
            if (this.kexer.isKexOngoing()) {
                Message m = Message.fromByte(payload.array()[payload.rpos()]);
                if (!m.in(1, 49) || m == Message.SERVICE_REQUEST) {
                    assert (m != Message.KEXINIT);
                    this.kexer.waitForDone();
                }
            } else if (this.encoder.getSequenceNumber() == 0L) {
                this.kexer.startKex(true);
            }
            long seq = this.encoder.encode(payload);
            try {
                this.connInfo.out.write(payload.array(), payload.rpos(), payload.available());
                this.connInfo.out.flush();
            }
            catch (IOException ioe) {
                throw new TransportException(ioe);
            }
            long l = seq;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void sendDisconnect(DisconnectReason reason, String message) {
        if (message == null) {
            message = "";
        }
        this.log.debug("Sending SSH_MSG_DISCONNECT: reason=[{}], msg=[{}]", (Object)reason, (Object)message);
        try {
            this.write((SSHPacket)((SSHPacket)((SSHPacket)new SSHPacket(Message.DISCONNECT).putInt(reason.toInt())).putString(message)).putString(""));
        }
        catch (IOException worthless) {
            this.log.debug("Error writing packet: {}", (Object)worthless.toString());
        }
    }

    @Override
    public void handle(Message msg, SSHPacket buf) throws SSHException {
        this.msg = msg;
        this.log.trace("Received packet {}", (Object)msg);
        if (msg.geq(50)) {
            this.service.handle(msg, buf);
        } else if (msg.in(20, 21) || msg.in(30, 49)) {
            this.kexer.handle(msg, buf);
        } else {
            switch (msg) {
                case DISCONNECT: {
                    this.gotDisconnect(buf);
                    break;
                }
                case IGNORE: {
                    this.log.info("Received SSH_MSG_IGNORE");
                    break;
                }
                case UNIMPLEMENTED: {
                    this.gotUnimplemented(buf);
                    break;
                }
                case DEBUG: {
                    this.gotDebug(buf);
                    break;
                }
                case SERVICE_ACCEPT: {
                    this.gotServiceAccept();
                    break;
                }
                default: {
                    this.sendUnimplemented();
                }
            }
        }
    }

    private void gotDebug(SSHPacket buf) {
        boolean display = buf.readBoolean();
        String message = buf.readString();
        this.log.info("Received SSH_MSG_DEBUG (display={}) '{}'", (Object)display, (Object)message);
    }

    private void gotDisconnect(SSHPacket buf) throws TransportException {
        DisconnectReason code = DisconnectReason.fromInt(buf.readInt());
        String message = buf.readString();
        this.log.info("Received SSH_MSG_DISCONNECT (reason={}, msg={})", (Object)code, (Object)message);
        throw new TransportException(code, "Disconnected; server said: " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotServiceAccept() throws TransportException {
        this.serviceAccept.lock();
        try {
            if (!this.serviceAccept.hasWaiters()) {
                throw new TransportException(DisconnectReason.PROTOCOL_ERROR, "Got a service accept notification when none was awaited");
            }
            this.serviceAccept.set();
        }
        finally {
            this.serviceAccept.unlock();
        }
    }

    private void gotUnimplemented(SSHPacket buf) throws SSHException {
        long seqNum = buf.readLong();
        this.log.info("Received SSH_MSG_UNIMPLEMENTED #{}", (Object)seqNum);
        if (this.kexer.isKexOngoing()) {
            throw new TransportException("Received SSH_MSG_UNIMPLEMENTED while exchanging keys");
        }
        this.getService().notifyUnimplemented(seqNum);
    }

    private void finishOff() {
        this.reader.interrupt();
        this.heartbeater.interrupt();
        IOUtils.closeQuietly(this.connInfo.in);
        IOUtils.closeQuietly(this.connInfo.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void die(Exception ex) {
        this.close.lock();
        try {
            if (!this.close.isSet()) {
                boolean gotRequiredInfo;
                this.log.error("Dying because - {}", (Object)ex.toString());
                SSHException causeOfDeath = SSHException.chainer.chain(ex);
                FutureUtils.alertAll((Throwable)causeOfDeath, this.close, this.serviceAccept);
                this.kexer.notifyError(causeOfDeath);
                this.getService().notifyError(causeOfDeath);
                this.setService(this.nullService);
                boolean didNotReceiveDisconnect = this.msg != Message.DISCONNECT;
                boolean bl = gotRequiredInfo = causeOfDeath.getDisconnectReason() != DisconnectReason.UNKNOWN;
                if (didNotReceiveDisconnect && gotRequiredInfo) {
                    this.sendDisconnect(causeOfDeath.getDisconnectReason(), causeOfDeath.getMessage());
                }
                this.finishOff();
                this.close.set();
            }
        }
        finally {
            this.close.unlock();
        }
    }

    String getClientID() {
        return this.clientID;
    }

    String getServerID() {
        return this.serverID;
    }

    Encoder getEncoder() {
        return this.encoder;
    }

    Decoder getDecoder() {
        return this.decoder;
    }

    ReentrantLock getWriteLock() {
        return this.writeLock;
    }

    ConnInfo getConnInfo() {
        return this.connInfo;
    }

    static final class ConnInfo {
        final String host;
        final int port;
        final InputStream in;
        final OutputStream out;

        public ConnInfo(String host, int port, InputStream in, OutputStream out) {
            this.host = host;
            this.port = port;
            this.in = in;
            this.out = out;
        }
    }

    private static final class NullService
    extends AbstractService {
        NullService(Transport trans) {
            super("null-service", trans);
        }
    }
}

