/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;

public class DH {
    private BigInteger p;
    private BigInteger g;
    private BigInteger e;
    private BigInteger f;
    private BigInteger K;
    private final KeyPairGenerator generator;
    private final KeyAgreement agreement;

    public DH() {
        try {
            this.generator = SecurityUtils.getKeyPairGenerator("DH");
            this.agreement = SecurityUtils.getKeyAgreement("DH");
        }
        catch (GeneralSecurityException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public void setF(BigInteger f) {
        this.f = f;
    }

    public void setG(BigInteger g) {
        this.g = g;
    }

    public void setP(BigInteger p) {
        this.p = p;
    }

    public byte[] getE() throws GeneralSecurityException {
        if (this.e == null) {
            this.generator.initialize(new DHParameterSpec(this.p, this.g));
            KeyPair kp = this.generator.generateKeyPair();
            this.agreement.init(kp.getPrivate());
            this.e = ((DHPublicKey)kp.getPublic()).getY();
        }
        return this.e.toByteArray();
    }

    public byte[] getK() throws GeneralSecurityException {
        if (this.K == null) {
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("DH");
            DHPublicKeySpec keySpec = new DHPublicKeySpec(this.f, this.p, this.g);
            PublicKey yourPubKey = keyFactory.generatePublic(keySpec);
            this.agreement.doPhase(yourPubKey, true);
            this.K = new BigInteger(this.agreement.generateSecret());
        }
        return this.K.toByteArray();
    }
}

