/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordResponseProvider
implements ChallengeResponseProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final char[] EMPTY_RESPONSE = new char[0];
    private static final Collection<String> DEFAULT_ACCEPTABLE_PROMPTS = Collections.unmodifiableCollection(Arrays.asList("Password:"));
    private final Collection<String> acceptablePrompts;
    private final PasswordFinder pwdf;
    private Resource resource;
    private boolean gaveAlready;

    public PasswordResponseProvider(PasswordFinder pwdf) {
        this(pwdf, DEFAULT_ACCEPTABLE_PROMPTS);
    }

    public PasswordResponseProvider(PasswordFinder pwdf, Collection<String> acceptablePrompts) {
        this.pwdf = pwdf;
        this.acceptablePrompts = acceptablePrompts;
    }

    @Override
    public List<String> getSubmethods() {
        return Collections.emptyList();
    }

    @Override
    public void init(Resource resource, String name, String instruction) {
        this.resource = resource;
        this.log.debug("Challenge - name=`{}`; instruction=`{}`", (Object)name, (Object)instruction);
    }

    @Override
    public char[] getResponse(String prompt, boolean echo) {
        if (!this.gaveAlready && !echo && this.acceptablePrompts.contains(prompt)) {
            this.gaveAlready = true;
            return this.pwdf.reqPassword(this.resource);
        }
        return EMPTY_RESPONSE;
    }

    @Override
    public boolean shouldRetry() {
        return this.pwdf.shouldRetry(this.resource);
    }
}

