/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.xfer.ModeGetter;
import net.schmizz.sshj.xfer.TransferListener;
import net.schmizz.sshj.xfer.scp.SCPEngine;

public final class SCPUploadClient
extends SCPEngine {
    private final ModeGetter modeGetter;
    private FileFilter fileFilter;

    SCPUploadClient(SessionFactory host, TransferListener listener, ModeGetter modeGetter) {
        super(host, listener);
        this.modeGetter = modeGetter;
    }

    @Override
    public synchronized int copy(String sourcePath, String targetPath) throws IOException {
        return super.copy(sourcePath, targetPath);
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    protected synchronized void startCopy(String sourcePath, String targetPath) throws IOException {
        this.init(targetPath);
        this.check("Start status OK");
        this.process(new File(sourcePath));
    }

    private File[] getChildren(File f) throws IOException {
        File[] files;
        File[] fileArray = files = this.fileFilter == null ? f.listFiles() : f.listFiles(this.fileFilter);
        if (files == null) {
            throw new IOException("Error listing files in directory: " + f);
        }
        return files;
    }

    private void init(String target) throws SSHException {
        LinkedList<SCPEngine.Arg> args = new LinkedList<SCPEngine.Arg>();
        args.add(SCPEngine.Arg.SINK);
        args.add(SCPEngine.Arg.RECURSIVE);
        if (this.modeGetter.preservesTimes()) {
            args.add(SCPEngine.Arg.PRESERVE_TIMES);
        }
        this.execSCPWith(args, target);
    }

    private void process(File f) throws IOException {
        if (f.isDirectory()) {
            this.listener.startedDir(f.getName());
            this.sendDirectory(f);
            this.listener.finishedDir();
        } else if (f.isFile()) {
            this.listener.startedFile(f.getName(), f.length());
            this.sendFile(f);
            this.listener.finishedFile();
        } else {
            throw new IOException(f + " is not a regular file or directory");
        }
    }

    private void sendDirectory(File f) throws IOException {
        this.preserveTimeIfPossible(f);
        this.sendMessage("D0" + this.getPermString(f) + " 0 " + f.getName());
        for (File child : this.getChildren(f)) {
            this.process(child);
        }
        this.sendMessage("E");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(File f) throws IOException {
        this.preserveTimeIfPossible(f);
        FileInputStream src = new FileInputStream(f);
        try {
            this.sendMessage("C0" + this.getPermString(f) + " " + f.length() + " " + f.getName());
            this.transfer(src, this.scp.getOutputStream(), this.scp.getRemoteMaxPacketSize(), f.length());
            this.signal("Transfer done");
            this.check("Remote agrees transfer done");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(src);
            throw throwable;
        }
        IOUtils.closeQuietly(src);
    }

    private void preserveTimeIfPossible(File f) throws IOException {
        if (this.modeGetter.preservesTimes()) {
            this.sendMessage("T" + this.modeGetter.getLastModifiedTime(f) + " 0 " + this.modeGetter.getLastAccessTime(f) + " 0");
        }
    }

    private String getPermString(File f) throws IOException {
        return Integer.toOctalString(this.modeGetter.getPermissions(f) & 0xFFF);
    }
}

