/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.schmizz.concurrent.Future;
import net.schmizz.concurrent.FutureUtils;
import net.schmizz.sshj.AbstractService;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.ErrorNotifiable;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.connection.channel.forwarded.ForwardedChannelOpener;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;

public class ConnectionImpl
extends AbstractService
implements Connection {
    private final Object internalSynchronizer = new Object();
    private final AtomicInteger nextID = new AtomicInteger();
    private final Map<Integer, Channel> channels = new ConcurrentHashMap<Integer, Channel>();
    private final Map<String, ForwardedChannelOpener> openers = new ConcurrentHashMap<String, ForwardedChannelOpener>();
    private final Queue<Future<SSHPacket, ConnectionException>> globalReqFutures = new LinkedList<Future<SSHPacket, ConnectionException>>();
    private int windowSize = 0x200000;
    private int maxPacketSize = 32768;

    public ConnectionImpl(Transport trans) {
        super("ssh-connection", trans);
    }

    @Override
    public void attach(Channel chan) {
        this.log.info("Attaching `{}` channel (#{})", (Object)chan.getType(), (Object)chan.getID());
        this.channels.put(chan.getID(), chan);
    }

    @Override
    public Channel get(int id) {
        return this.channels.get(id);
    }

    @Override
    public ForwardedChannelOpener get(String chanType) {
        return this.openers.get(chanType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Channel chan) {
        this.log.info("Forgetting `{}` channel (#{})", (Object)chan.getType(), (Object)chan.getID());
        this.channels.remove(chan.getID());
        Object object = this.internalSynchronizer;
        synchronized (object) {
            if (this.channels.isEmpty()) {
                this.internalSynchronizer.notifyAll();
            }
        }
    }

    @Override
    public void forget(ForwardedChannelOpener opener) {
        this.log.info("Forgetting opener for `{}` channels: {}", (Object)opener.getChannelType(), (Object)opener);
        this.openers.remove(opener.getChannelType());
    }

    @Override
    public void attach(ForwardedChannelOpener opener) {
        this.log.info("Attaching opener for `{}` channels: {}", (Object)opener.getChannelType(), (Object)opener);
        this.openers.put(opener.getChannelType(), opener);
    }

    private Channel getChannel(SSHPacket buffer) throws ConnectionException {
        int recipient = buffer.readInt();
        Channel channel = this.get(recipient);
        if (channel != null) {
            return channel;
        }
        buffer.rpos(buffer.rpos() - 5);
        throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Received " + (Object)((Object)buffer.readMessageID()) + " on unknown channel #" + recipient);
    }

    @Override
    public void handle(Message msg, SSHPacket buf) throws SSHException {
        if (msg.in(91, 100)) {
            this.getChannel(buf).handle(msg, buf);
        } else if (msg.in(80, 90)) {
            switch (msg) {
                case REQUEST_SUCCESS: {
                    this.gotGlobalReqResponse(buf);
                    break;
                }
                case REQUEST_FAILURE: {
                    this.gotGlobalReqResponse(null);
                    break;
                }
                case CHANNEL_OPEN: {
                    this.gotChannelOpen(buf);
                    break;
                }
                default: {
                    super.handle(msg, buf);
                    break;
                }
            }
        } else {
            super.handle(msg, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyError(SSHException error) {
        super.notifyError(error);
        Queue<Future<SSHPacket, ConnectionException>> queue = this.globalReqFutures;
        synchronized (queue) {
            FutureUtils.alertAll((Throwable)error, this.globalReqFutures);
            this.globalReqFutures.clear();
        }
        ErrorNotifiable.Util.alertAll(error, this.channels.values());
        this.channels.clear();
    }

    @Override
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    @Override
    public Transport getTransport() {
        return this.trans;
    }

    @Override
    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        Object object = this.internalSynchronizer;
        synchronized (object) {
            while (!this.channels.isEmpty()) {
                this.internalSynchronizer.wait();
            }
        }
    }

    @Override
    public int nextID() {
        return this.nextID.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<SSHPacket, ConnectionException> sendGlobalRequest(String name, boolean wantReply, byte[] specifics) throws TransportException {
        Queue<Future<SSHPacket, ConnectionException>> queue = this.globalReqFutures;
        synchronized (queue) {
            this.log.info("Making global request for `{}`", (Object)name);
            this.trans.write((SSHPacket)((SSHPacket)((SSHPacket)new SSHPacket(Message.GLOBAL_REQUEST).putString(name)).putBoolean(wantReply)).putRawBytes(specifics));
            Future future = null;
            if (wantReply) {
                future = new Future("global req for " + name, ConnectionException.chainer);
                this.globalReqFutures.add(future);
            }
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotGlobalReqResponse(SSHPacket response) throws ConnectionException {
        Queue<Future<SSHPacket, ConnectionException>> queue = this.globalReqFutures;
        synchronized (queue) {
            Future<SSHPacket, ConnectionException> gr = this.globalReqFutures.poll();
            if (gr == null) {
                throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Got a global request response when none was requested");
            }
            if (response == null) {
                gr.error(new ConnectionException("Global request [" + gr + "] failed"));
            } else {
                gr.set(response);
            }
        }
    }

    private void gotChannelOpen(SSHPacket buf) throws ConnectionException, TransportException {
        String type = buf.readString();
        this.log.debug("Received CHANNEL_OPEN for `{}` channel", (Object)type);
        if (this.openers.containsKey(type)) {
            this.openers.get(type).handleOpen(buf);
        } else {
            this.log.warn("No opener found for `{}` CHANNEL_OPEN request -- rejecting", (Object)type);
            this.sendOpenFailure(buf.readInt(), OpenFailException.Reason.UNKNOWN_CHANNEL_TYPE, "");
        }
    }

    @Override
    public void sendOpenFailure(int recipient, OpenFailException.Reason reason, String message) throws TransportException {
        this.trans.write((SSHPacket)((SSHPacket)((SSHPacket)new SSHPacket(Message.CHANNEL_OPEN_FAILURE).putInt(recipient)).putInt(reason.getCode())).putString(message));
    }

    @Override
    public void notifyDisconnect() throws SSHException {
        super.notifyDisconnect();
        ConnectionException ex = new ConnectionException("Disconnected.");
        FutureUtils.alertAll((Throwable)ex, this.globalReqFutures);
        ErrorNotifiable.Util.alertAll((SSHException)ex, new HashSet<Channel>(this.channels.values()));
    }
}

