/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.forwarded;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.connection.channel.forwarded.AbstractForwardedChannel;
import net.schmizz.sshj.connection.channel.forwarded.AbstractForwardedChannelOpener;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.transport.TransportException;

public class RemotePortForwarder
extends AbstractForwardedChannelOpener {
    protected static final String PF_REQ = "tcpip-forward";
    protected static final String PF_CANCEL = "cancel-tcpip-forward";
    protected final Map<Forward, ConnectListener> listeners = new ConcurrentHashMap<Forward, ConnectListener>();

    public RemotePortForwarder(Connection conn) {
        super("forwarded-tcpip", conn);
    }

    public Forward bind(Forward forward, ConnectListener listener) throws ConnectionException, TransportException {
        SSHPacket reply = this.req(PF_REQ, forward);
        if (forward.port == 0) {
            forward.port = reply.readInt();
        }
        this.log.info("Remote end listening on {}", (Object)forward);
        this.listeners.put(forward, listener);
        return forward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Forward forward) throws ConnectionException, TransportException {
        try {
            this.req(PF_CANCEL, forward);
        }
        finally {
            this.listeners.remove(forward);
        }
    }

    protected SSHPacket req(String reqName, Forward forward) throws ConnectionException, TransportException {
        byte[] specifics = ((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(forward.address)).putInt(forward.port)).getCompactData();
        return this.conn.sendGlobalRequest(reqName, true, specifics).get(this.conn.getTimeout(), TimeUnit.SECONDS);
    }

    public Set<Forward> getActiveForwards() {
        return this.listeners.keySet();
    }

    @Override
    public void handleOpen(SSHPacket buf) throws ConnectionException, TransportException {
        ForwardedTCPIPChannel chan = new ForwardedTCPIPChannel(this.conn, buf.readInt(), buf.readInt(), buf.readInt(), new Forward(buf.readString(), buf.readInt()), buf.readString(), buf.readInt());
        if (this.listeners.containsKey(chan.getParentForward())) {
            this.callListener(this.listeners.get(chan.getParentForward()), chan);
        } else {
            chan.reject(OpenFailException.Reason.ADMINISTRATIVELY_PROHIBITED, "Forwarding was not requested on `" + chan.getParentForward() + "`");
        }
    }

    public static class ForwardedTCPIPChannel
    extends AbstractForwardedChannel {
        public static final String TYPE = "forwarded-tcpip";
        private final Forward fwd;

        public ForwardedTCPIPChannel(Connection conn, int recipient, int remoteWinSize, int remoteMaxPacketSize, Forward fwd, String origIP, int origPort) {
            super(conn, TYPE, recipient, remoteWinSize, remoteMaxPacketSize, origIP, origPort);
            this.fwd = fwd;
        }

        public Forward getParentForward() {
            return this.fwd;
        }
    }

    public static final class Forward {
        private final String address;
        private int port;

        public Forward(int port) {
            this("", port);
        }

        public Forward(String address) {
            this(address, 0);
        }

        public Forward(String address, int port) {
            this.address = address;
            this.port = port;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Forward other = (Forward)obj;
            return this.address.equals(other.address) && this.port == other.port;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.address + ":" + this.port;
        }
    }
}

