/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.forwarded;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketForwardingConnectListener
implements ConnectListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SocketAddress addr;

    public SocketForwardingConnectListener(SocketAddress addr) {
        this.addr = addr;
    }

    @Override
    public void gotConnect(Channel.Forwarded chan) throws IOException {
        this.log.info("New connection from " + chan.getOriginatorIP() + ":" + chan.getOriginatorPort());
        final Socket sock = new Socket();
        sock.setSendBufferSize(chan.getLocalMaxPacketSize());
        sock.setReceiveBufferSize(chan.getRemoteMaxPacketSize());
        sock.connect(this.addr);
        chan.confirm();
        StreamCopier.ErrorCallback closer = StreamCopier.closeOnErrorCallback(chan, new Closeable(){

            @Override
            public void close() throws IOException {
                sock.close();
            }
        });
        new StreamCopier("soc2chan", sock.getInputStream(), chan.getOutputStream()).bufSize(chan.getRemoteMaxPacketSize()).errorCallback(closer).daemon(true).start();
        new StreamCopier("chan2soc", chan.getInputStream(), sock.getOutputStream()).bufSize(chan.getLocalMaxPacketSize()).errorCallback(closer).daemon(true).start();
    }
}

