/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

public class PathComponents {
    private final String parent;
    private final String name;
    private final String path;

    public static String adjustForParent(String parent, String path) {
        return path.startsWith("/") ? path : parent + (parent.endsWith("/") ? "" : "/") + path;
    }

    private static String trimFinalSlash(String path) {
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    public PathComponents(String parent, String name) {
        this.parent = parent;
        this.name = name;
        this.path = PathComponents.adjustForParent(parent, name);
    }

    public String getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (o instanceof PathComponents) {
            PathComponents that = (PathComponents)o;
            return PathComponents.trimFinalSlash(this.path).equals(PathComponents.trimFinalSlash(that.path));
        }
        return false;
    }

    public int hashCode() {
        return PathComponents.trimFinalSlash(this.path).hashCode();
    }

    public String toString() {
        return "[parent=" + this.parent + "; name=" + this.name + "; path=" + this.path + "]";
    }
}

