/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;

public class KeyProviderUtil {
    public static FileKeyProvider.Format detectKeyFileFormat(File location) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(location));
        String firstLine = br.readLine();
        IOUtils.closeQuietly(br);
        if (firstLine == null) {
            throw new IOException("Empty file");
        }
        if (firstLine.startsWith("-----BEGIN") && firstLine.endsWith("PRIVATE KEY-----")) {
            if (new File(location + ".pub").exists()) {
                return FileKeyProvider.Format.OpenSSH;
            }
            return FileKeyProvider.Format.PKCS8;
        }
        return FileKeyProvider.Format.Unknown;
    }
}

