/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer;

import java.io.File;
import java.io.IOException;
import net.schmizz.sshj.xfer.FilePermission;
import net.schmizz.sshj.xfer.ModeSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModeSetter
implements ModeSetter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void setLastAccessedTime(File f, long t) throws IOException {
    }

    @Override
    public void setLastModifiedTime(File f, long t) throws IOException {
        if (!f.setLastModified(t * 1000L)) {
            this.log.warn("Could not set last modified time for {} to {}", (Object)f, (Object)t);
        }
    }

    @Override
    public void setPermissions(File f, int perms) throws IOException {
        boolean r = f.setReadable(FilePermission.USR_R.isIn(perms), !FilePermission.OTH_R.isIn(perms) && !FilePermission.GRP_R.isIn(perms));
        boolean w = f.setWritable(FilePermission.USR_W.isIn(perms), !FilePermission.OTH_W.isIn(perms) && !FilePermission.GRP_W.isIn(perms));
        boolean x = f.setExecutable(FilePermission.USR_X.isIn(perms), !FilePermission.OTH_X.isIn(perms) && !FilePermission.GRP_X.isIn(perms));
        if (!(r && w && x)) {
            this.log.warn("Could not set permissions for {} to {}", (Object)f, (Object)Integer.toString(perms, 16));
        }
    }

    @Override
    public boolean preservesTimes() {
        return true;
    }
}

