/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.xfer.TransferListener;
import net.schmizz.sshj.xfer.scp.SCPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SCPEngine {
    static final String SCP_COMMAND = "scp";
    static final char LF = '\n';
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final SessionFactory host;
    final TransferListener listener;
    Session.Command scp;
    int exitStatus;

    SCPEngine(SessionFactory host, TransferListener listener) {
        this.host = host;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copy(String sourcePath, String targetPath) throws IOException {
        this.cleanSlate();
        try {
            this.startCopy(sourcePath, targetPath);
        }
        finally {
            this.exit();
        }
        return this.exitStatus;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    void check(String what) throws IOException {
        int code = this.scp.getInputStream().read();
        switch (code) {
            case -1: {
                String stderr = this.scp.getErrorAsString();
                if (!stderr.isEmpty()) {
                    stderr = ". Additional info: `" + stderr + "`";
                }
                throw new SCPException("EOF while expecting response to protocol message" + stderr);
            }
            case 0: {
                this.log.debug(what);
                return;
            }
            case 1: 
            case 2: {
                throw new SCPException("Remote SCP command had error: " + this.readMessage());
            }
        }
        throw new SCPException("Received unknown response code");
    }

    void cleanSlate() {
        this.exitStatus = -1;
    }

    void execSCPWith(List<Arg> args, String path) throws SSHException {
        StringBuilder cmd = new StringBuilder(SCP_COMMAND);
        for (Arg arg : args) {
            cmd.append(" ").append((Object)arg);
        }
        cmd.append(" ").append(path == null || path.equals("") ? "." : path);
        this.scp = this.host.startSession().exec(cmd.toString());
    }

    void exit() {
        if (this.scp != null) {
            IOUtils.closeQuietly(this.scp);
            if (this.scp.getExitStatus() != null) {
                this.exitStatus = this.scp.getExitStatus();
                if (this.scp.getExitStatus() != 0) {
                    this.log.warn("SCP exit status: {}", (Object)this.scp.getExitStatus());
                }
            } else {
                this.exitStatus = -1;
            }
            if (this.scp.getExitSignal() != null) {
                this.log.warn("SCP exit signal: {}", (Object)this.scp.getExitSignal());
            }
        }
        this.scp = null;
    }

    String readMessage() throws IOException {
        return this.readMessage(true);
    }

    String readMessage(boolean errOnEOF) throws IOException {
        int x;
        StringBuilder sb = new StringBuilder();
        while ((x = this.scp.getInputStream().read()) != 10) {
            if (x == -1) {
                if (errOnEOF) {
                    throw new IOException("EOF while reading message");
                }
                return null;
            }
            sb.append((char)x);
        }
        this.log.debug("Read message: {}", (Object)sb);
        return sb.toString();
    }

    void sendMessage(String msg) throws IOException {
        this.log.debug("Sending message: {}", (Object)msg);
        this.scp.getOutputStream().write((msg + '\n').getBytes());
        this.scp.getOutputStream().flush();
        this.check("Message ACK received");
    }

    void signal(String what) throws IOException {
        this.log.debug("Signalling: {}", (Object)what);
        this.scp.getOutputStream().write(0);
        this.scp.getOutputStream().flush();
    }

    abstract void startCopy(String var1, String var2) throws IOException;

    void transfer(InputStream in, OutputStream out, int bufSize, long len) throws IOException {
        byte[] buf = new byte[bufSize];
        long count = 0L;
        int read = 0;
        long startTime = System.currentTimeMillis();
        while (count < len && (read = in.read(buf, 0, (int)Math.min((long)bufSize, len - count))) != -1) {
            out.write(buf, 0, read);
            this.listener.reportProgress(count += (long)read);
        }
        out.flush();
        double sizeKiB = (double)count / 1024.0;
        double timeSeconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        this.log.info(sizeKiB + " KiB transferred  in {} seconds ({} KiB/s)", (Object)timeSeconds, (Object)(sizeKiB / timeSeconds));
        if (read == -1) {
            throw new IOException("Had EOF before transfer completed");
        }
    }

    static enum Arg {
        SOURCE('f'),
        SINK('t'),
        RECURSIVE('r'),
        VERBOSE('v'),
        PRESERVE_TIMES('p'),
        QUIET('q');

        private final char a;

        private Arg(char a) {
            this.a = a;
        }

        public String toString() {
            return "-" + this.a;
        }
    }
}

