/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import net.schmizz.sshj.ConfigImpl;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.signature.SignatureDSA;
import net.schmizz.sshj.signature.SignatureRSA;
import net.schmizz.sshj.transport.cipher.AES128CBC;
import net.schmizz.sshj.transport.cipher.AES128CTR;
import net.schmizz.sshj.transport.cipher.AES192CBC;
import net.schmizz.sshj.transport.cipher.AES192CTR;
import net.schmizz.sshj.transport.cipher.AES256CBC;
import net.schmizz.sshj.transport.cipher.AES256CTR;
import net.schmizz.sshj.transport.cipher.BlowfishCBC;
import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.transport.cipher.TripleDESCBC;
import net.schmizz.sshj.transport.compression.NoneCompression;
import net.schmizz.sshj.transport.kex.DHG1;
import net.schmizz.sshj.transport.kex.DHG14;
import net.schmizz.sshj.transport.mac.HMACMD5;
import net.schmizz.sshj.transport.mac.HMACMD596;
import net.schmizz.sshj.transport.mac.HMACSHA1;
import net.schmizz.sshj.transport.mac.HMACSHA196;
import net.schmizz.sshj.transport.random.BouncyCastleRandom;
import net.schmizz.sshj.transport.random.JCERandom;
import net.schmizz.sshj.transport.random.SingletonRandomFactory;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfig
extends ConfigImpl {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String VERSION = "SSHJ_0_3";

    public DefaultConfig() {
        this.setVersion(VERSION);
        boolean bouncyCastleRegistered = SecurityUtils.isBouncyCastleRegistered();
        this.initKeyExchangeFactories(bouncyCastleRegistered);
        this.initRandomFactory(bouncyCastleRegistered);
        this.initFileKeyProviderFactories(bouncyCastleRegistered);
        this.initCipherFactories();
        this.initCompressionFactories();
        this.initMACFactories();
        this.initSignatureFactories();
    }

    protected void initKeyExchangeFactories(boolean bouncyCastleRegistered) {
        if (bouncyCastleRegistered) {
            this.setKeyExchangeFactories(new DHG14.Factory(), new DHG1.Factory());
        } else {
            this.setKeyExchangeFactories(new DHG1.Factory());
        }
    }

    protected void initRandomFactory(boolean bouncyCastleRegistered) {
        this.setRandomFactory(new SingletonRandomFactory(bouncyCastleRegistered ? new BouncyCastleRandom.Factory() : new JCERandom.Factory()));
    }

    protected void initFileKeyProviderFactories(boolean bouncyCastleRegistered) {
        if (bouncyCastleRegistered) {
            this.setFileKeyProviderFactories(new PKCS8KeyFile.Factory(), new OpenSSHKeyFile.Factory());
        }
    }

    protected void initCipherFactories() {
        LinkedList<Factory.Named<Cipher>> avail = new LinkedList<Factory.Named<Cipher>>(Arrays.asList(new AES128CTR.Factory(), new AES192CTR.Factory(), new AES256CTR.Factory(), new AES128CBC.Factory(), new AES192CBC.Factory(), new AES256CBC.Factory(), new TripleDESCBC.Factory(), new BlowfishCBC.Factory()));
        boolean warn = false;
        Iterator i = avail.iterator();
        while (i.hasNext()) {
            Factory.Named f = (Factory.Named)i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (Exception e) {
                warn = true;
                i.remove();
            }
        }
        if (warn) {
            this.log.warn("Disabling high-strength ciphers: cipher strengths apparently limited by JCE policy");
        }
        this.setCipherFactories(avail);
    }

    protected void initSignatureFactories() {
        this.setSignatureFactories(new SignatureRSA.Factory(), new SignatureDSA.Factory());
    }

    protected void initMACFactories() {
        this.setMACFactories(new HMACSHA1.Factory(), new HMACSHA196.Factory(), new HMACMD5.Factory(), new HMACMD596.Factory());
    }

    protected void initCompressionFactories() {
        this.setCompressionFactories(new NoneCompression.Factory());
    }
}

