/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.LinkedList;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.SocketClient;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.ConnectionImpl;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionChannel;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.connection.channel.forwarded.RemotePortForwarder;
import net.schmizz.sshj.connection.channel.forwarded.X11Forwarder;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.TransportImpl;
import net.schmizz.sshj.transport.compression.DelayedZlibCompression;
import net.schmizz.sshj.transport.compression.NoneCompression;
import net.schmizz.sshj.transport.compression.ZlibCompression;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import net.schmizz.sshj.userauth.UserAuth;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.UserAuthImpl;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyPairWrapper;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyProviderUtil;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import net.schmizz.sshj.userauth.method.PasswordResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import net.schmizz.sshj.userauth.password.Resource;
import net.schmizz.sshj.xfer.scp.SCPFileTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHClient
extends SocketClient
implements SessionFactory {
    public static final int DEFAULT_PORT = 22;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Transport trans;
    protected final UserAuth auth;
    protected final Connection conn;

    public SSHClient() {
        this(new DefaultConfig());
    }

    public SSHClient(Config config) {
        super(22);
        this.trans = new TransportImpl(config);
        this.auth = new UserAuthImpl(this.trans);
        this.conn = new ConnectionImpl(this.trans);
    }

    public void addHostKeyVerifier(HostKeyVerifier hostKeyVerifier) {
        this.trans.addHostKeyVerifier(hostKeyVerifier);
    }

    public void addHostKeyVerifier(final String fingerprint) {
        this.addHostKeyVerifier(new HostKeyVerifier(){

            @Override
            public boolean verify(String h, int p, PublicKey k) {
                return SecurityUtils.getFingerprint(k).equals(fingerprint);
            }
        });
    }

    public void auth(String username, AuthMethod ... methods) throws UserAuthException, TransportException {
        assert (this.isConnected());
        this.auth(username, Arrays.asList(methods));
    }

    public void auth(String username, Iterable<AuthMethod> methods) throws UserAuthException, TransportException {
        assert (this.isConnected());
        this.auth.authenticate(username, (Service)((Object)this.conn), methods);
    }

    public void authPassword(String username, String password) throws UserAuthException, TransportException {
        this.authPassword(username, password.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authPassword(String username, final char[] password) throws UserAuthException, TransportException {
        try {
            this.authPassword(username, new PasswordFinder(){

                @Override
                public char[] reqPassword(Resource<?> resource) {
                    return (char[])password.clone();
                }

                @Override
                public boolean shouldRetry(Resource<?> resource) {
                    return false;
                }
            });
        }
        finally {
            PasswordUtils.blankOut(password);
        }
    }

    public void authPassword(String username, PasswordFinder pfinder) throws UserAuthException, TransportException {
        this.auth(username, new AuthPassword(pfinder), new AuthKeyboardInteractive(new PasswordResponseProvider(pfinder)));
    }

    public void authPublickey(String username) throws UserAuthException, TransportException {
        String base = System.getProperty("user.home") + File.separator + ".ssh" + File.separator;
        this.authPublickey(username, base + "id_rsa", base + "id_dsa");
    }

    public void authPublickey(String username, Iterable<KeyProvider> keyProviders) throws UserAuthException, TransportException {
        LinkedList<AuthMethod> am = new LinkedList<AuthMethod>();
        for (KeyProvider kp : keyProviders) {
            am.add(new AuthPublickey(kp));
        }
        this.auth(username, am);
    }

    public void authPublickey(String username, KeyProvider ... keyProviders) throws UserAuthException, TransportException {
        this.authPublickey(username, Arrays.asList(keyProviders));
    }

    public void authPublickey(String username, String ... locations) throws UserAuthException, TransportException {
        LinkedList<KeyProvider> keyProviders = new LinkedList<KeyProvider>();
        for (String loc : locations) {
            try {
                this.log.debug("Attempting to load key from: {}", (Object)loc);
                keyProviders.add(this.loadKeys(loc));
            }
            catch (IOException logged) {
                this.log.warn("Could not load keys due to: {}", (Throwable)logged);
            }
        }
        this.authPublickey(username, keyProviders);
    }

    @Override
    public void disconnect() throws IOException {
        assert (this.isConnected());
        this.trans.disconnect();
        super.disconnect();
        assert (!this.isConnected());
    }

    public Connection getConnection() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotePortForwarder getRemotePortForwarder() {
        Connection connection = this.conn;
        synchronized (connection) {
            RemotePortForwarder rpf = (RemotePortForwarder)this.conn.get("forwarded-tcpip");
            if (rpf == null) {
                rpf = new RemotePortForwarder(this.conn);
                this.conn.attach(rpf);
            }
            return rpf;
        }
    }

    public Transport getTransport() {
        return this.trans;
    }

    public UserAuth getUserAuth() {
        return this.auth;
    }

    public boolean isAuthenticated() {
        return this.trans.isAuthenticated();
    }

    @Override
    public boolean isConnected() {
        return super.isConnected() && this.trans.isRunning();
    }

    public KeyProvider loadKeys(KeyPair kp) {
        return new KeyPairWrapper(kp);
    }

    public KeyProvider loadKeys(String location) throws IOException {
        return this.loadKeys(location, (PasswordFinder)null);
    }

    public KeyProvider loadKeys(String location, char[] passphrase) throws IOException {
        return this.loadKeys(location, PasswordUtils.createOneOff(passphrase));
    }

    public KeyProvider loadKeys(String location, PasswordFinder passwordFinder) throws IOException {
        File loc = new File(location);
        FileKeyProvider.Format format = KeyProviderUtil.detectKeyFileFormat(loc);
        FileKeyProvider fkp = (FileKeyProvider)Factory.Named.Util.create(this.trans.getConfig().getFileKeyProviderFactories(), format.toString());
        if (fkp == null) {
            throw new SSHException("No provider available for " + (Object)((Object)format) + " key file");
        }
        fkp.init(loc, passwordFinder);
        return fkp;
    }

    public KeyProvider loadKeys(String location, String passphrase) throws IOException {
        return this.loadKeys(location, passphrase.toCharArray());
    }

    public void loadKnownHosts() throws IOException {
        boolean loaded = false;
        File sshDir = OpenSSHKnownHosts.detectSSHDir();
        if (sshDir != null) {
            for (File loc : Arrays.asList(new File(sshDir, "known_hosts"), new File(sshDir, "known_hosts2"))) {
                try {
                    this.loadKnownHosts(loc);
                    loaded = true;
                }
                catch (IOException e) {}
            }
        }
        if (!loaded) {
            throw new IOException("Could not load known_hosts");
        }
    }

    public void loadKnownHosts(File location) throws IOException {
        this.addHostKeyVerifier(new OpenSSHKnownHosts(location));
    }

    public LocalPortForwarder newLocalPortForwarder(SocketAddress address, String host, int port) throws IOException {
        return new LocalPortForwarder(this.getServerSocketFactory(), this.conn, address, host, port);
    }

    public X11Forwarder registerX11Forwarder(ConnectListener listener) {
        X11Forwarder x11f = new X11Forwarder(this.conn, listener);
        this.conn.attach(x11f);
        return x11f;
    }

    public SCPFileTransfer newSCPFileTransfer() {
        assert (this.isConnected() && this.isAuthenticated());
        return new SCPFileTransfer(this);
    }

    public SFTPClient newSFTPClient() throws IOException {
        assert (this.isConnected() && this.isAuthenticated());
        return new SFTPClient(new SFTPEngine(this).init());
    }

    public void rekey() throws TransportException {
        this.doKex();
    }

    @Override
    public Session startSession() throws ConnectionException, TransportException {
        assert (this.isConnected() && this.isAuthenticated());
        SessionChannel sess = new SessionChannel(this.conn);
        sess.open();
        assert (sess.isOpen());
        return sess;
    }

    public void useCompression() throws TransportException {
        this.trans.getConfig().setCompressionFactories(Arrays.asList(new DelayedZlibCompression.Factory(), new ZlibCompression.Factory(), new NoneCompression.Factory()));
        if (this.isConnected()) {
            this.rekey();
        }
    }

    @Override
    protected void onConnect() throws IOException {
        super.onConnect();
        this.trans.init(this.getRemoteHostname(), this.getRemotePort(), this.getInputStream(), this.getOutputStream());
        this.doKex();
    }

    protected void doKex() throws TransportException {
        assert (this.trans.isRunning());
        long start = System.currentTimeMillis();
        this.trans.doKex();
        this.log.info("Key exchange took {} seconds", (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
    }
}

