/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.schmizz.concurrent.Promise;
import net.schmizz.sshj.sftp.Request;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketReader
extends Thread {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InputStream in;
    private final Map<Long, Promise<Response, SFTPException>> promises = new ConcurrentHashMap<Long, Promise<Response, SFTPException>>();
    private final SFTPPacket<Response> packet = new SFTPPacket();
    private final byte[] lenBuf = new byte[4];
    private final SFTPEngine engine;

    public PacketReader(SFTPEngine engine) {
        this.engine = engine;
        this.in = engine.getSubsystem().getInputStream();
        this.setName("sftp reader");
    }

    private void readIntoBuffer(byte[] buf, int off, int len) throws IOException {
        int read = 0;
        for (int count = 0; count < len && (read = this.in.read(buf, off + count, len - count)) != -1; count += read) {
        }
        if (read == -1) {
            throw new SFTPException("EOF while reading packet");
        }
    }

    private int getPacketLength() throws IOException {
        this.readIntoBuffer(this.lenBuf, 0, this.lenBuf.length);
        return (int)((long)(this.lenBuf[0] << 24) & 0xFF000000L | (long)(this.lenBuf[1] << 16) & 0xFF0000L | (long)(this.lenBuf[2] << 8) & 0xFF00L | (long)this.lenBuf[3] & 0xFFL);
    }

    public SFTPPacket<Response> readPacket() throws IOException {
        int len = this.getPacketLength();
        if (len > 0x40000000) {
            throw new IllegalStateException("Invalid packet: indicated length " + len + " too large");
        }
        this.packet.rpos(0);
        this.packet.wpos(0);
        this.packet.ensureCapacity(len);
        this.readIntoBuffer(this.packet.array(), 0, len);
        this.packet.wpos(len);
        return this.packet;
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                this.readPacket();
                this.handle();
            }
        }
        catch (IOException e) {
            for (Promise<Response, SFTPException> promise : this.promises.values()) {
                promise.deliverError(e);
            }
        }
    }

    public void handle() throws SFTPException {
        Response resp = new Response(this.packet, this.engine.getOperativeProtocolVersion());
        Promise<Response, SFTPException> promise = this.promises.remove(resp.getRequestID());
        this.log.debug("Received {} packet", (Object)resp.getType());
        if (promise == null) {
            throw new SFTPException("Received [" + (Object)((Object)resp.readType()) + "] response for request-id " + resp.getRequestID() + ", no such request was made");
        }
        promise.deliver(resp);
    }

    public void expectResponseTo(Request req) {
        this.promises.put(req.getRequestID(), req.getResponsePromise());
    }
}

