/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.cli;

import com.beust.jcommander.JCommander;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.seninp.gi.GIAlgorithm;
import net.seninp.gi.cli.GrammarStats;
import net.seninp.gi.cli.TS2GrammarParameters;
import net.seninp.gi.logic.GIUtils;
import net.seninp.gi.logic.GrammarRuleRecord;
import net.seninp.gi.logic.GrammarRules;
import net.seninp.gi.logic.RuleInterval;
import net.seninp.gi.repair.RePairFactory;
import net.seninp.gi.repair.RePairGrammar;
import net.seninp.gi.sequitur.SAXRule;
import net.seninp.gi.sequitur.SequiturFactory;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.datastructure.SAXRecords;
import net.seninp.util.StackTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TS2Grammar {
    private static final String CR = "\n";
    private static TSProcessor tp = new TSProcessor();
    private static NormalAlphabet na = new NormalAlphabet();
    private static SAXProcessor sp = new SAXProcessor();
    private static final Logger LOGGER = LoggerFactory.getLogger(TS2Grammar.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int n;
        int n2;
        Object grammar;
        TS2GrammarParameters params = new TS2GrammarParameters();
        JCommander jct = new JCommander((Object)params);
        if (0 == args.length) {
            jct.usage();
            System.exit(10);
        }
        jct.parse(args);
        StringBuffer sb = new StringBuffer(1024);
        sb.append("GrammarViz2 CLI converter v.1").append(CR);
        sb.append("parameters:").append(CR);
        sb.append("  input file:                  ").append(TS2GrammarParameters.IN_FILE).append(CR);
        sb.append("  output file:                 ").append(TS2GrammarParameters.OUT_FILE).append(CR);
        sb.append("  SAX sliding window size:     ").append(TS2GrammarParameters.SAX_WINDOW_SIZE).append(CR);
        sb.append("  SAX PAA size:                ").append(TS2GrammarParameters.SAX_PAA_SIZE).append(CR);
        sb.append("  SAX alphabet size:           ").append(TS2GrammarParameters.SAX_ALPHABET_SIZE).append(CR);
        sb.append("  SAX numerosity reduction:    ").append(TS2GrammarParameters.SAX_NR_STRATEGY).append(CR);
        sb.append("  SAX normalization threshold: ").append(TS2GrammarParameters.SAX_NORM_THRESHOLD).append(CR);
        sb.append("  GI implementation:           ").append((Object)TS2GrammarParameters.GI_ALGORITHM_IMPLEMENTATION).append(CR);
        sb.append(CR);
        System.out.println(sb.toString());
        LOGGER.info("Reading data ...");
        double[] series = tp.readTS(TS2GrammarParameters.IN_FILE, 0);
        LOGGER.info("read " + series.length + " points from " + TS2GrammarParameters.IN_FILE);
        LOGGER.info("Performing SAX conversion ...");
        SAXRecords saxData = sp.ts2saxViaWindow(series, TS2GrammarParameters.SAX_WINDOW_SIZE, TS2GrammarParameters.SAX_PAA_SIZE, na.getCuts(Integer.valueOf(TS2GrammarParameters.SAX_ALPHABET_SIZE)), TS2GrammarParameters.SAX_NR_STRATEGY, TS2GrammarParameters.SAX_NORM_THRESHOLD);
        String discretizedTS = saxData.getSAXString(" ");
        GrammarRules rules = new GrammarRules();
        if (GIAlgorithm.SEQUITUR == TS2GrammarParameters.GI_ALGORITHM_IMPLEMENTATION) {
            LOGGER.info("Inferring Sequitur grammar ...");
            grammar = SequiturFactory.runSequitur(discretizedTS);
            rules = ((SAXRule)grammar).toGrammarRulesData();
            SequiturFactory.updateRuleIntervals(rules, saxData, true, series, TS2GrammarParameters.SAX_WINDOW_SIZE, TS2GrammarParameters.SAX_PAA_SIZE);
        } else if (GIAlgorithm.REPAIR == TS2GrammarParameters.GI_ALGORITHM_IMPLEMENTATION) {
            LOGGER.info("Inferring RePair grammar ...");
            grammar = RePairFactory.buildGrammar(discretizedTS);
            ((RePairGrammar)grammar).expandRules();
            ((RePairGrammar)grammar).buildIntervals(saxData, series, TS2GrammarParameters.SAX_WINDOW_SIZE);
            rules = ((RePairGrammar)grammar).toGrammarRulesData();
        }
        LOGGER.info("Collecting stats ...");
        LOGGER.info("Producing the output ...");
        String fname = TS2GrammarParameters.OUT_FILE;
        boolean fileOpen = false;
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(new File(fname)));
            fileOpen = true;
            bw.write("#" + sb.toString().replaceAll(CR, "\n#"));
        }
        catch (IOException e) {
            System.err.print("Encountered an error while writing stats file: \n" + StackTrace.toString((Throwable)e) + CR);
        }
        GrammarStats grammarStats = new GrammarStats();
        for (GrammarRuleRecord grammarRuleRecord : rules) {
            grammarStats.process(grammarRuleRecord);
            sb = new StringBuffer();
            sb.append("/// ").append(grammarRuleRecord.getRuleName()).append(CR);
            sb.append(grammarRuleRecord.getRuleName()).append(" -> '").append(grammarRuleRecord.getRuleString().trim()).append("', expanded rule string: '").append(grammarRuleRecord.getExpandedRuleString()).append("'").append(CR);
            if (!grammarRuleRecord.getOccurrences().isEmpty()) {
                ArrayList<RuleInterval> arrayList = grammarRuleRecord.getRuleIntervals();
                int[] starts = new int[arrayList.size()];
                int[] nArray = new int[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    starts[i] = arrayList.get(i).getStart();
                    nArray[i] = arrayList.get(i).getEnd() - arrayList.get(i).getStart();
                }
                sb.append("subsequence starts: ").append(Arrays.toString(starts)).append(CR);
                sb.append("subsequence lengths: ").append(Arrays.toString(nArray)).append(CR);
            }
            sb.append("rule occurrence frequency ").append(grammarRuleRecord.getOccurrences().size()).append(CR);
            sb.append("rule use frequency ").append(grammarRuleRecord.getRuleUseFrequency()).append(CR);
            sb.append("min length ").append(grammarRuleRecord.minMaxLengthAsString().split(" - ")[0]).append(CR);
            sb.append("max length ").append(grammarRuleRecord.minMaxLengthAsString().split(" - ")[1]).append(CR);
            sb.append("mean length ").append(grammarRuleRecord.getMeanLength()).append(CR);
            if (!fileOpen) continue;
            try {
                bw.write(sb.toString());
            }
            catch (IOException iOException) {
                System.err.print("Encountered an error while writing stats file: \n" + StackTrace.toString((Throwable)iOException) + CR);
            }
        }
        int[] coverageArray = new int[series.length];
        for (GrammarRuleRecord grammarRuleRecord : rules) {
            if (0 == grammarRuleRecord.ruleNumber()) continue;
            ArrayList<RuleInterval> arrPos = grammarRuleRecord.getRuleIntervals();
            for (RuleInterval saxPos : arrPos) {
                int startPos = saxPos.getStart();
                int endPos = saxPos.getEnd();
                for (int j = startPos; j < endPos; ++j) {
                    coverageArray[j] = coverageArray[j] + 1;
                }
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        int coverageSum = 0;
        for (int i : coverageArray) {
            coverageSum += i;
            if (i < n2) {
                n2 = i;
            }
            if (i <= n) continue;
            n = i;
        }
        double d = (double)coverageSum / (double)series.length;
        List<RuleInterval> zeros = GIUtils.getZeroIntervals(coverageArray);
        int zerosSize = 0;
        for (RuleInterval i : zeros) {
            zerosSize += i.getLength();
        }
        if (fileOpen) {
            bw.write(grammarStats.toString());
            bw.write("# coverage\t" + n2 + "\t" + n + "\t" + d + CR);
            bw.write("# non-covered intervals " + zeros.size() + ", of total " + zerosSize + " point(s)\n");
            bw.write("#\n# " + grammarStats.toSingleLine() + "\t" + n2 + "\t" + n + "\t" + d + CR);
        }
        try {
            if (fileOpen) {
                bw.close();
            }
        }
        catch (IOException e) {
            System.err.print("Encountered an error while writing stats file: \n" + StackTrace.toString((Throwable)e) + CR);
        }
        finally {
            bw.close();
        }
    }
}

