/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.clusterrule;

import java.util.ArrayList;
import net.seninp.gi.clusterrule.RuleOrganizer;
import net.seninp.gi.logic.GrammarRules;
import net.seninp.gi.logic.PackedRuleRecord;
import net.seninp.gi.logic.SameLengthMotifs;

public class ClusterRuleFactory {
    public static ArrayList<SameLengthMotifs> performPruning(double[] ts, GrammarRules grammarRules, double thresholdLength, double thresholdCom, double fractionTopDist) {
        RuleOrganizer ro = new RuleOrganizer();
        ArrayList<SameLengthMotifs> allClassifiedMotifs = ro.classifyMotifs(thresholdLength, grammarRules);
        allClassifiedMotifs = ro.removeOverlappingInSimiliar(allClassifiedMotifs, grammarRules, ts, thresholdCom);
        ArrayList<SameLengthMotifs> newAllClassifiedMotifs = ro.refinePatternsByClustering(grammarRules, ts, allClassifiedMotifs, fractionTopDist);
        return newAllClassifiedMotifs;
    }

    public static ArrayList<PackedRuleRecord> getPackedRule(ArrayList<SameLengthMotifs> newAllClassifiedMotifs) {
        ArrayList<PackedRuleRecord> arrPackedRuleRecords = new ArrayList<PackedRuleRecord>();
        int i = 0;
        for (SameLengthMotifs subsequencesInClass : newAllClassifiedMotifs) {
            int classIndex = i++;
            int subsequencesNumber = subsequencesInClass.getSameLenMotifs().size();
            int minLength = subsequencesInClass.getMinMotifLen();
            int maxLength = subsequencesInClass.getMaxMotifLen();
            PackedRuleRecord packedRuleRecord = new PackedRuleRecord();
            packedRuleRecord.setClassIndex(classIndex);
            packedRuleRecord.setSubsequenceNumber(subsequencesNumber);
            packedRuleRecord.setMinLength(minLength);
            packedRuleRecord.setMaxLength(maxLength);
            arrPackedRuleRecords.add(packedRuleRecord);
        }
        return arrPackedRuleRecords;
    }
}

