/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.clusterrule;

import com.apporiented.algorithm.clustering.AverageLinkageStrategy;
import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.DefaultClusteringAlgorithm;
import com.apporiented.algorithm.clustering.LinkageStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.seninp.gi.clusterrule.DistanceComputation;
import net.seninp.gi.logic.GrammarRules;
import net.seninp.gi.logic.RuleInterval;
import net.seninp.gi.logic.SAXMotif;
import net.seninp.gi.logic.SAXPointsNumber;
import net.seninp.gi.logic.SameLengthMotifs;

public class RuleOrganizer {
    public ArrayList<SameLengthMotifs> classifyMotifs(double lengthThreshold, GrammarRules grammarRules) {
        ArrayList<SameLengthMotifs> allClassifiedMotifs = new ArrayList<SameLengthMotifs>();
        ArrayList<SAXMotif> allMotifs = this.getAllMotifs(grammarRules);
        int currentIndex = 0;
        for (SAXMotif tmpMotif : allMotifs) {
            int tmpMotifLen;
            ++currentIndex;
            if (tmpMotif.isClassified()) continue;
            SameLengthMotifs tmpSameLengthMotifs = new SameLengthMotifs();
            int minLen = tmpMotifLen = tmpMotif.getPos().getEnd() - tmpMotif.getPos().getStart() + 1;
            int maxLen = tmpMotifLen;
            ArrayList<SAXMotif> newMotifClass = new ArrayList<SAXMotif>();
            newMotifClass.add(tmpMotif);
            tmpMotif.setClassified(true);
            for (int i = currentIndex; i < allMotifs.size(); ++i) {
                SAXMotif anotherMotif = allMotifs.get(i);
                int anotherMotifLen = anotherMotif.getPos().getEnd() - anotherMotif.getPos().getStart() + 1;
                if (!((double)Math.abs(anotherMotifLen - tmpMotifLen) < (double)tmpMotifLen * lengthThreshold)) continue;
                newMotifClass.add(anotherMotif);
                anotherMotif.setClassified(true);
                if (anotherMotifLen > maxLen) {
                    maxLen = anotherMotifLen;
                    continue;
                }
                if (anotherMotifLen >= minLen) continue;
                minLen = anotherMotifLen;
            }
            tmpSameLengthMotifs.setSameLenMotifs(newMotifClass);
            tmpSameLengthMotifs.setMinMotifLen(minLen);
            tmpSameLengthMotifs.setMaxMotifLen(maxLen);
            allClassifiedMotifs.add(tmpSameLengthMotifs);
        }
        return allClassifiedMotifs;
    }

    protected ArrayList<SAXMotif> getAllMotifs(GrammarRules grammarRules) {
        ArrayList<SAXMotif> allMotifs = new ArrayList<SAXMotif>();
        int ruleNumber = grammarRules.size();
        for (int i = 0; i < ruleNumber; ++i) {
            ArrayList<RuleInterval> arrPos = grammarRules.getRuleRecord(i).getRuleIntervals();
            for (RuleInterval saxPos : arrPos) {
                SAXMotif motif = new SAXMotif();
                motif.setPos(saxPos);
                motif.setRuleIndex(i);
                motif.setClassified(false);
                allMotifs.add(motif);
            }
        }
        Collections.sort(allMotifs);
        return allMotifs;
    }

    protected ArrayList<SameLengthMotifs> removeOverlappingInSimiliar(ArrayList<SameLengthMotifs> allClassifiedMotifs, GrammarRules grammarRules, double[] ts, double thresouldCom) {
        ArrayList<SAXMotif> motifsBeDeleted = new ArrayList<SAXMotif>();
        SAXPointsNumber[] pointsNumberRemoveStrategy = this.countPointNumber(grammarRules, ts);
        for (SameLengthMotifs sameLenMotifs : allClassifiedMotifs) {
            block1: for (int j = 0; j < sameLenMotifs.getSameLenMotifs().size(); ++j) {
                SAXMotif tempMotif = sameLenMotifs.getSameLenMotifs().get(j);
                int tempMotifLen = tempMotif.getPos().getEnd() - tempMotif.getPos().getStart() + 1;
                for (int i = j + 1; i < sameLenMotifs.getSameLenMotifs().size(); ++i) {
                    boolean isAnotherBetter;
                    double maxStartPos;
                    SAXMotif anotherMotif = sameLenMotifs.getSameLenMotifs().get(i);
                    int anotherMotifLen = anotherMotif.getPos().getEnd() - anotherMotif.getPos().getStart() + 1;
                    double minEndPos = Math.min(tempMotif.getPos().getEnd(), anotherMotif.getPos().getEnd());
                    double commonLen = minEndPos - (maxStartPos = (double)Math.max(tempMotif.getPos().getStart(), anotherMotif.getPos().getStart())) + 1.0;
                    if (!(commonLen > (double)tempMotifLen * thresouldCom)) continue;
                    SAXMotif deletedMotif = new SAXMotif();
                    SAXMotif similarWith = new SAXMotif();
                    if (pointsNumberRemoveStrategy != null) {
                        isAnotherBetter = this.decideRemove(anotherMotif, tempMotif, pointsNumberRemoveStrategy);
                    } else {
                        boolean bl = isAnotherBetter = anotherMotifLen > tempMotifLen;
                    }
                    if (isAnotherBetter) {
                        deletedMotif = tempMotif;
                        similarWith = anotherMotif;
                        sameLenMotifs.getSameLenMotifs().remove(j);
                        deletedMotif.setSimilarWith(similarWith);
                        motifsBeDeleted.add(deletedMotif);
                        --j;
                        continue block1;
                    }
                    deletedMotif = anotherMotif;
                    similarWith = tempMotif;
                    sameLenMotifs.getSameLenMotifs().remove(i);
                    deletedMotif.setSimilarWith(similarWith);
                    motifsBeDeleted.add(deletedMotif);
                    --i;
                }
            }
            int minLength = sameLenMotifs.getSameLenMotifs().get((int)0).getPos().endPos - sameLenMotifs.getSameLenMotifs().get((int)0).getPos().startPos + 1;
            int sameLenMotifsSize = sameLenMotifs.getSameLenMotifs().size();
            int maxLength = sameLenMotifs.getSameLenMotifs().get((int)(sameLenMotifsSize - 1)).getPos().endPos - sameLenMotifs.getSameLenMotifs().get((int)(sameLenMotifsSize - 1)).getPos().startPos + 1;
            sameLenMotifs.setMinMotifLen(minLength);
            sameLenMotifs.setMaxMotifLen(maxLength);
        }
        return allClassifiedMotifs;
    }

    public SAXPointsNumber[] countPointNumberAfterRemoving(double[] ts, ArrayList<SameLengthMotifs> allClassifiedMotifs) {
        SAXPointsNumber[] pointsNumber = new SAXPointsNumber[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            pointsNumber[i] = new SAXPointsNumber();
            pointsNumber[i].setPointIndex(i);
            pointsNumber[i].setPointValue(ts[i]);
        }
        for (SameLengthMotifs sameLenMotifs : allClassifiedMotifs) {
            for (SAXMotif motif : sameLenMotifs.getSameLenMotifs()) {
                RuleInterval pos = motif.getPos();
                for (int i = pos.getStart(); i <= pos.getEnd() - 1; ++i) {
                    pointsNumber[i].setPointOccurenceNumber(pointsNumber[i].getPointOccurenceNumber() + 1);
                }
            }
        }
        return pointsNumber;
    }

    protected boolean decideRemove(SAXMotif motif1, SAXMotif motif2, SAXPointsNumber[] pointsNumberRemoveStrategy) {
        int i;
        int motif1Start = motif1.getPos().getStart();
        int motif1End = motif1.getPos().getEnd() - 1;
        int length1 = motif1End - motif1Start;
        int motif2Start = motif2.getPos().getStart();
        int motif2End = motif1.getPos().getEnd() - 1;
        int length2 = motif2End - motif2Start;
        int countsMotif1 = 0;
        int countsMotif2 = 0;
        double averageWeight = 1.0;
        int count = 0;
        for (i = 0; i < pointsNumberRemoveStrategy.length; ++i) {
            count += pointsNumberRemoveStrategy[i].getPointOccurenceNumber();
        }
        averageWeight = (double)count / (double)pointsNumberRemoveStrategy.length;
        for (i = motif1Start; i <= motif1End; ++i) {
            countsMotif1 += pointsNumberRemoveStrategy[i].getPointOccurenceNumber();
        }
        for (i = motif2Start; i <= motif2End; ++i) {
            countsMotif2 += pointsNumberRemoveStrategy[i].getPointOccurenceNumber();
        }
        double weight1 = (double)countsMotif1 / (averageWeight * (double)length1);
        double weight2 = (double)countsMotif2 / (averageWeight * (double)length2);
        return weight1 > weight2;
    }

    protected SAXPointsNumber[] countPointNumber(GrammarRules grammarRules, double[] ts) {
        SAXPointsNumber[] pointsNumber = new SAXPointsNumber[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            pointsNumber[i] = new SAXPointsNumber();
            pointsNumber[i].setPointIndex(i);
            pointsNumber[i].setPointValue(ts[i]);
        }
        int rulesNum = grammarRules.size();
        for (int i = 0; i < rulesNum; ++i) {
            ArrayList<RuleInterval> arrPos = grammarRules.getRuleRecord(i).getRuleIntervals();
            for (RuleInterval saxPos : arrPos) {
                int start = saxPos.getStart();
                int end = saxPos.getEnd() - 1;
                for (int position = start; position <= end; ++position) {
                    pointsNumber[position].setPointOccurenceNumber(pointsNumber[position].getPointOccurenceNumber() + 1);
                }
            }
        }
        return pointsNumber;
    }

    protected ArrayList<SameLengthMotifs> refinePatternsByClustering(GrammarRules grammarRules, double[] ts, ArrayList<SameLengthMotifs> allClassifiedMotifs, double fractionTopDist) {
        DistanceComputation dc = new DistanceComputation();
        double[] origTS = ts;
        ArrayList<SameLengthMotifs> newAllClassifiedMotifs = new ArrayList<SameLengthMotifs>();
        for (SameLengthMotifs sameLenMotifs : allClassifiedMotifs) {
            ArrayList<RuleInterval> arrPos = new ArrayList<RuleInterval>();
            ArrayList<SAXMotif> subsequences = sameLenMotifs.getSameLenMotifs();
            for (SAXMotif ss : subsequences) {
                arrPos.add(ss.getPos());
            }
            int patternNum = arrPos.size();
            if (patternNum < 2) continue;
            double[][] dt = new double[patternNum][patternNum];
            for (int i = 0; i < patternNum; ++i) {
                RuleInterval saxPos = (RuleInterval)arrPos.get(i);
                int start1 = saxPos.getStart();
                int end1 = saxPos.getEnd();
                double[] ts1 = Arrays.copyOfRange(origTS, start1, end1);
                for (int j = 0; j < arrPos.size(); ++j) {
                    int end2;
                    double d;
                    RuleInterval saxPos2 = (RuleInterval)arrPos.get(j);
                    if (dt[i][j] > 0.0) continue;
                    dt[i][j] = d = 0.0;
                    if (i == j) continue;
                    int start2 = saxPos2.getStart();
                    double[] ts2 = Arrays.copyOfRange(origTS, start2, end2 = saxPos2.getEnd());
                    d = ts1.length > ts2.length ? dc.calcDistTSAndPattern(ts1, ts2) : dc.calcDistTSAndPattern(ts2, ts1);
                    dt[i][j] = d;
                }
            }
            String[] patternsName = new String[patternNum];
            for (int i = 0; i < patternNum; ++i) {
                patternsName[i] = String.valueOf(i);
            }
            DefaultClusteringAlgorithm alg = new DefaultClusteringAlgorithm();
            Cluster cluster = alg.performClustering(dt, patternsName, (LinkageStrategy)new AverageLinkageStrategy());
            int minPatternPerCls = 1;
            if (cluster.getDistance() == null) continue;
            double cutDist = cluster.getDistanceValue() * fractionTopDist;
            ArrayList<String[]> clusterTSIdx = this.findCluster(cluster, cutDist, minPatternPerCls);
            while (clusterTSIdx.size() <= 0) {
                cutDist += cutDist / 2.0;
                clusterTSIdx = this.findCluster(cluster, cutDist, minPatternPerCls);
            }
            newAllClassifiedMotifs.addAll(this.SeparateMotifsByClustering(clusterTSIdx, sameLenMotifs));
        }
        return newAllClassifiedMotifs;
    }

    private ArrayList<String[]> findCluster(Cluster cluster, double cutDist, int minPatternPerCls) {
        ArrayList<String[]> clusterTSIdx = new ArrayList<String[]>();
        if (cluster.getDistance() != null) {
            if (cluster.getDistanceValue() > cutDist) {
                if (cluster.getChildren().size() > 0) {
                    clusterTSIdx.addAll(this.findCluster((Cluster)cluster.getChildren().get(0), cutDist, minPatternPerCls));
                    clusterTSIdx.addAll(this.findCluster((Cluster)cluster.getChildren().get(1), cutDist, minPatternPerCls));
                }
            } else {
                ArrayList<String> itemsInCluster = this.getNameInCluster(cluster);
                String[] idxes = itemsInCluster.toArray(new String[itemsInCluster.size()]);
                if (idxes.length > minPatternPerCls) {
                    clusterTSIdx.add(idxes);
                }
            }
        }
        return clusterTSIdx;
    }

    private ArrayList<String> getNameInCluster(Cluster cluster) {
        ArrayList<String> itemsInCluster = new ArrayList<String>();
        if (cluster.isLeaf()) {
            String nodeName = cluster.getName();
            itemsInCluster.add(nodeName);
        }
        for (Cluster child : cluster.getChildren()) {
            ArrayList<String> childrenNames = this.getNameInCluster(child);
            itemsInCluster.addAll(childrenNames);
        }
        return itemsInCluster;
    }

    private ArrayList<SameLengthMotifs> SeparateMotifsByClustering(ArrayList<String[]> clusterTSIdx, SameLengthMotifs sameLenMotifs) {
        ArrayList<SameLengthMotifs> newResult = new ArrayList<SameLengthMotifs>();
        if (clusterTSIdx.size() > 1) {
            ArrayList<SAXMotif> subsequences = sameLenMotifs.getSameLenMotifs();
            for (String[] idxesInCluster : clusterTSIdx) {
                SameLengthMotifs newIthSLM = new SameLengthMotifs();
                ArrayList<SAXMotif> sameLenSS = new ArrayList<SAXMotif>();
                int minL = sameLenMotifs.getMinMotifLen();
                int maxL = sameLenMotifs.getMaxMotifLen();
                for (String i : idxesInCluster) {
                    SAXMotif ssI = subsequences.get(Integer.parseInt(i));
                    int len = ssI.getPos().getEnd() - ssI.getPos().getStart();
                    if (len < minL) {
                        minL = len;
                    } else if (len > maxL) {
                        maxL = len;
                    }
                    sameLenSS.add(ssI);
                }
                newIthSLM.setSameLenMotifs(sameLenSS);
                newIthSLM.setMaxMotifLen(maxL);
                newIthSLM.setMinMotifLen(minL);
                newResult.add(newIthSLM);
            }
        } else {
            newResult.add(sameLenMotifs);
        }
        return newResult;
    }
}

