/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.logic;

import java.util.ArrayList;
import java.util.List;
import net.seninp.gi.logic.GrammarRuleRecord;
import net.seninp.gi.logic.GrammarRules;
import net.seninp.gi.logic.RuleInterval;

public class GIUtils {
    private GIUtils() {
    }

    public static double mean(int[] values) {
        double sum = 0.0;
        for (int i : values) {
            sum += (double)i;
        }
        return sum / (double)values.length;
    }

    public static List<RuleInterval> getZeroIntervals(int[] coverageArray) {
        ArrayList<RuleInterval> res = new ArrayList<RuleInterval>();
        int start = -1;
        boolean inInterval = false;
        int intervalsCounter = -1;
        for (int i = 0; i < coverageArray.length; ++i) {
            if (0 == coverageArray[i] && !inInterval) {
                start = i;
                inInterval = true;
            }
            if (coverageArray[i] <= 0 || !inInterval) continue;
            res.add(new RuleInterval(intervalsCounter, start, i, 0.0));
            inInterval = false;
            --intervalsCounter;
        }
        if (inInterval) {
            res.add(new RuleInterval(intervalsCounter, start, coverageArray.length, 0.0));
        }
        return res;
    }

    public static double getCoverAsFraction(int seriesLength, GrammarRules rules) {
        boolean[] coverageArray = new boolean[seriesLength];
        for (GrammarRuleRecord rule : rules) {
            if (0 == rule.ruleNumber()) continue;
            ArrayList<RuleInterval> arrPos = rule.getRuleIntervals();
            for (RuleInterval saxPos : arrPos) {
                int startPos = saxPos.getStart();
                int endPos = saxPos.getEnd();
                for (int j = startPos; j < endPos; ++j) {
                    coverageArray[j] = true;
                }
            }
        }
        int coverSum = 0;
        for (int i = 0; i < seriesLength; ++i) {
            if (!coverageArray[i]) continue;
            ++coverSum;
        }
        return (double)coverSum / (double)seriesLength;
    }

    public static double getMeanRuleCoverage(int length, GrammarRules rules) {
        int[] coverageArray = new int[length];
        for (GrammarRuleRecord rule : rules) {
            if (0 == rule.ruleNumber()) continue;
            ArrayList<RuleInterval> arrPos = rule.getRuleIntervals();
            for (RuleInterval saxPos : arrPos) {
                int startPos = saxPos.getStart();
                int endPos = saxPos.getEnd();
                for (int j = startPos; j < endPos; ++j) {
                    coverageArray[j] = coverageArray[j] + 1;
                }
            }
        }
        int coverageSum = 0;
        for (int i : coverageArray) {
            coverageSum += i;
        }
        return (double)coverageSum / (double)length;
    }
}

