/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.logic;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.seninp.gi.logic.GrammarRuleRecord;

public class GrammarRules
implements Iterable<GrammarRuleRecord>,
Serializable {
    private static final long serialVersionUID = 3982321937773958595L;
    private SortedMap<Integer, GrammarRuleRecord> rules = new TreeMap<Integer, GrammarRuleRecord>();

    public void addRule(GrammarRuleRecord arrRule) {
        int key = arrRule.getRuleNumber();
        this.rules.put(key, arrRule);
    }

    public GrammarRuleRecord getRuleRecord(Integer ruleIdx) {
        return (GrammarRuleRecord)this.rules.get(ruleIdx);
    }

    @Override
    public Iterator<GrammarRuleRecord> iterator() {
        return this.rules.values().iterator();
    }

    public GrammarRuleRecord get(Integer ruleIndex) {
        return (GrammarRuleRecord)this.rules.get(ruleIndex);
    }

    public int size() {
        return this.rules.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<Integer, GrammarRuleRecord> rr : this.rules.entrySet()) {
            sb.append(rr.getValue().getRuleName());
            sb.append(" -> ").append(rr.getValue().getRuleString());
            sb.append(" -> ").append(rr.getValue().getExpandedRuleString());
            sb.append("\n");
        }
        return sb.delete(sb.length() - 1, sb.length()).toString();
    }

    public int getHighestFrequency() {
        int res = 0;
        for (GrammarRuleRecord r : this.rules.values()) {
            if (0 == r.getRuleNumber() || r.getOccurrences().size() <= res) continue;
            res = r.getOccurrences().size();
        }
        return res;
    }
}

